// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.
 */
public class CustomMessageActivity private constructor(builder: Builder) {
    /**
     * The destination to send the campaign or treatment to. This value can be one of the following:
     * + The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.
     * + The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.
     */
    public val deliveryUri: kotlin.String? = builder.deliveryUri
    /**
     * The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.
     */
    public val endpointTypes: List<EndpointTypesElement>? = builder.endpointTypes
    /**
     * Specifies the message data included in a custom channel message that's sent to participants in a journey.
     */
    public val messageConfig: aws.sdk.kotlin.services.pinpoint.model.JourneyCustomMessage? = builder.messageConfig
    /**
     * The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.
     */
    public val nextActivity: kotlin.String? = builder.nextActivity
    /**
     * The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link>Template Versions resource.
     *
     * If you don't specify a value for this property, Amazon Pinpoint uses the *active version* of the template. The *active version* is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
     */
    public val templateVersion: kotlin.String? = builder.templateVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CustomMessageActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomMessageActivity(")
        append("deliveryUri=$deliveryUri,")
        append("endpointTypes=$endpointTypes,")
        append("messageConfig=$messageConfig,")
        append("nextActivity=$nextActivity,")
        append("templateName=$templateName,")
        append("templateVersion=$templateVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryUri?.hashCode() ?: 0
        result = 31 * result + (endpointTypes?.hashCode() ?: 0)
        result = 31 * result + (messageConfig?.hashCode() ?: 0)
        result = 31 * result + (nextActivity?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomMessageActivity

        if (deliveryUri != other.deliveryUri) return false
        if (endpointTypes != other.endpointTypes) return false
        if (messageConfig != other.messageConfig) return false
        if (nextActivity != other.nextActivity) return false
        if (templateName != other.templateName) return false
        if (templateVersion != other.templateVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CustomMessageActivity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The destination to send the campaign or treatment to. This value can be one of the following:
         * + The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.
         * + The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.
         */
        public var deliveryUri: kotlin.String? = null
        /**
         * The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.
         */
        public var endpointTypes: List<EndpointTypesElement>? = null
        /**
         * Specifies the message data included in a custom channel message that's sent to participants in a journey.
         */
        public var messageConfig: aws.sdk.kotlin.services.pinpoint.model.JourneyCustomMessage? = null
        /**
         * The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.
         */
        public var nextActivity: kotlin.String? = null
        /**
         * The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link>Template Versions resource.
         *
         * If you don't specify a value for this property, Amazon Pinpoint uses the *active version* of the template. The *active version* is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
         */
        public var templateVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CustomMessageActivity) : this() {
            this.deliveryUri = x.deliveryUri
            this.endpointTypes = x.endpointTypes
            this.messageConfig = x.messageConfig
            this.nextActivity = x.nextActivity
            this.templateName = x.templateName
            this.templateVersion = x.templateVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CustomMessageActivity = CustomMessageActivity(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyCustomMessage] inside the given [block]
         */
        public fun messageConfig(block: aws.sdk.kotlin.services.pinpoint.model.JourneyCustomMessage.Builder.() -> kotlin.Unit) {
            this.messageConfig = aws.sdk.kotlin.services.pinpoint.model.JourneyCustomMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
