// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.
 */
public class CreateRecommenderConfigurationShape private constructor(builder: Builder) {
    /**
     * A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.
     *
     * In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:
     * + An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.
     * + An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
     *
     * This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:
     * + PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     * + PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.
     */
    public val recommendationProviderIdType: kotlin.String? = builder.recommendationProviderIdType
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.
     */
    public val recommendationProviderRoleArn: kotlin.String? = builder.recommendationProviderRoleArn
    /**
     * The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.
     */
    public val recommendationProviderUri: kotlin.String? = builder.recommendationProviderUri
    /**
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.
     */
    public val recommendationTransformerUri: kotlin.String? = builder.recommendationTransformerUri
    /**
     * A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     *
     * This name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.
     */
    public val recommendationsDisplayName: kotlin.String? = builder.recommendationsDisplayName
    /**
     * The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.
     *
     * To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public val recommendationsPerMessage: kotlin.Int? = builder.recommendationsPerMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationShape = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRecommenderConfigurationShape(")
        append("attributes=$attributes,")
        append("description=$description,")
        append("name=$name,")
        append("recommendationProviderIdType=$recommendationProviderIdType,")
        append("recommendationProviderRoleArn=$recommendationProviderRoleArn,")
        append("recommendationProviderUri=$recommendationProviderUri,")
        append("recommendationTransformerUri=$recommendationTransformerUri,")
        append("recommendationsDisplayName=$recommendationsDisplayName,")
        append("recommendationsPerMessage=$recommendationsPerMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderIdType?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderRoleArn?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderUri?.hashCode() ?: 0)
        result = 31 * result + (recommendationTransformerUri?.hashCode() ?: 0)
        result = 31 * result + (recommendationsDisplayName?.hashCode() ?: 0)
        result = 31 * result + (recommendationsPerMessage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRecommenderConfigurationShape

        if (attributes != other.attributes) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (recommendationProviderIdType != other.recommendationProviderIdType) return false
        if (recommendationProviderRoleArn != other.recommendationProviderRoleArn) return false
        if (recommendationProviderUri != other.recommendationProviderUri) return false
        if (recommendationTransformerUri != other.recommendationTransformerUri) return false
        if (recommendationsDisplayName != other.recommendationsDisplayName) return false
        if (recommendationsPerMessage != other.recommendationsPerMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationShape = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.
         *
         * In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:
         * + An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.
         * + An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
         *
         * This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in your request.
         */
        public var attributes: Map<String, String>? = null
        /**
         * A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
         */
        public var description: kotlin.String? = null
        /**
         * A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
         */
        public var name: kotlin.String? = null
        /**
         * The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:
         * + PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         * + PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.
         */
        public var recommendationProviderIdType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.
         */
        public var recommendationProviderRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.
         */
        public var recommendationProviderUri: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that's retrieved from the recommender model.
         */
        public var recommendationTransformerUri: kotlin.String? = null
        /**
         * A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         *
         * This name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don't apply to attribute values.
         */
        public var recommendationsDisplayName: kotlin.String? = null
        /**
         * The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.
         *
         * To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         */
        public var recommendationsPerMessage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationShape) : this() {
            this.attributes = x.attributes
            this.description = x.description
            this.name = x.name
            this.recommendationProviderIdType = x.recommendationProviderIdType
            this.recommendationProviderRoleArn = x.recommendationProviderRoleArn
            this.recommendationProviderUri = x.recommendationProviderUri
            this.recommendationTransformerUri = x.recommendationTransformerUri
            this.recommendationsDisplayName = x.recommendationsDisplayName
            this.recommendationsPerMessage = x.recommendationsPerMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationShape = CreateRecommenderConfigurationShape(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
