// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * For a campaign, specifies limits on the messages that the campaign can send. For an application, specifies the default limits for messages that campaigns in the application can send.
 */
public class CampaignLimits private constructor(builder: Builder) {
    /**
     * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.
     */
    public val daily: kotlin.Int? = builder.daily
    /**
     * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.
     */
    public val maximumDuration: kotlin.Int? = builder.maximumDuration
    /**
     * The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 1. The maximum value is 20,000.
     */
    public val messagesPerSecond: kotlin.Int? = builder.messagesPerSecond
    /**
     * The maximum total number of messages that the campaign can send per user session.
     */
    public val session: kotlin.Int? = builder.session
    /**
     * The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.
     */
    public val total: kotlin.Int? = builder.total

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CampaignLimits = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignLimits(")
        append("daily=$daily,")
        append("maximumDuration=$maximumDuration,")
        append("messagesPerSecond=$messagesPerSecond,")
        append("session=$session,")
        append("total=$total")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = daily ?: 0
        result = 31 * result + (maximumDuration ?: 0)
        result = 31 * result + (messagesPerSecond ?: 0)
        result = 31 * result + (session ?: 0)
        result = 31 * result + (total ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignLimits

        if (daily != other.daily) return false
        if (maximumDuration != other.maximumDuration) return false
        if (messagesPerSecond != other.messagesPerSecond) return false
        if (session != other.session) return false
        if (total != other.total) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CampaignLimits = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.
         */
        public var daily: kotlin.Int? = null
        /**
         * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.
         */
        public var maximumDuration: kotlin.Int? = null
        /**
         * The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 1. The maximum value is 20,000.
         */
        public var messagesPerSecond: kotlin.Int? = null
        /**
         * The maximum total number of messages that the campaign can send per user session.
         */
        public var session: kotlin.Int? = null
        /**
         * The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.
         */
        public var total: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits) : this() {
            this.daily = x.daily
            this.maximumDuration = x.maximumDuration
            this.messagesPerSecond = x.messagesPerSecond
            this.session = x.session
            this.total = x.total
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CampaignLimits = CampaignLimits(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
