// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the content and "From" address for an email message that's sent to recipients of a campaign.
 */
public class CampaignEmailMessage private constructor(builder: Builder) {
    /**
     * The body of the email for recipients whose email clients don't render HTML content.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.
     */
    public val fromAddress: kotlin.String? = builder.fromAddress
    /**
     * The list of [MessageHeaders](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader) for the email. You can have up to 15 MessageHeaders for each email.
     */
    public val headers: List<MessageHeader>? = builder.headers
    /**
     * The body of the email, in HTML format, for recipients whose email clients render HTML content.
     */
    public val htmlBody: kotlin.String? = builder.htmlBody
    /**
     * The subject line, or title, of the email.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignEmailMessage(")
        append("body=$body,")
        append("fromAddress=$fromAddress,")
        append("headers=$headers,")
        append("htmlBody=$htmlBody,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (fromAddress?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (htmlBody?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignEmailMessage

        if (body != other.body) return false
        if (fromAddress != other.fromAddress) return false
        if (headers != other.headers) return false
        if (htmlBody != other.htmlBody) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The body of the email for recipients whose email clients don't render HTML content.
         */
        public var body: kotlin.String? = null
        /**
         * The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.
         */
        public var fromAddress: kotlin.String? = null
        /**
         * The list of [MessageHeaders](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader) for the email. You can have up to 15 MessageHeaders for each email.
         */
        public var headers: List<MessageHeader>? = null
        /**
         * The body of the email, in HTML format, for recipients whose email clients render HTML content.
         */
        public var htmlBody: kotlin.String? = null
        /**
         * The subject line, or title, of the email.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage) : this() {
            this.body = x.body
            this.fromAddress = x.fromAddress
            this.headers = x.headers
            this.htmlBody = x.htmlBody
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage = CampaignEmailMessage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
