// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the type and the names of attributes that were removed from all the endpoints that are associated with an application.
 */
public class AttributesResource private constructor(builder: Builder) {
    /**
     * The unique identifier for the application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The type of attribute or attributes that were removed from the endpoints. Valid values are:
     * + endpoint-custom-attributes - Custom attributes that describe endpoints.
     * + endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints.
     * + endpoint-user-attributes - Custom attributes that describe users.
     */
    public val attributeType: kotlin.String? = builder.attributeType
    /**
     * An array that specifies the names of the attributes that were removed from the endpoints.
     */
    public val attributes: List<String>? = builder.attributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.AttributesResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributesResource(")
        append("applicationId=$applicationId,")
        append("attributeType=$attributeType,")
        append("attributes=$attributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (attributeType?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributesResource

        if (applicationId != other.applicationId) return false
        if (attributeType != other.attributeType) return false
        if (attributes != other.attributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.AttributesResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The type of attribute or attributes that were removed from the endpoints. Valid values are:
         * + endpoint-custom-attributes - Custom attributes that describe endpoints.
         * + endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints.
         * + endpoint-user-attributes - Custom attributes that describe users.
         */
        public var attributeType: kotlin.String? = null
        /**
         * An array that specifies the names of the attributes that were removed from the endpoints.
         */
        public var attributes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.AttributesResource) : this() {
            this.applicationId = x.applicationId
            this.attributeType = x.attributeType
            this.attributes = x.attributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.AttributesResource = AttributesResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
