// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about an application, including the default settings for an application.
 */
public class ApplicationSettingsResource private constructor(builder: Builder) {
    /**
     * The unique identifier for the application. This identifier is displayed as the **Project ID** on the Amazon Pinpoint console.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.
     */
    public val campaignHook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = builder.campaignHook
    /**
     * The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.
     */
    public val journeyLimits: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits? = builder.journeyLimits
    /**
     * The date and time, in ISO 8601 format, when the application's settings were last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The default sending limits for campaigns in the application.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = builder.limits
    /**
     * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:
     * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
     * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
     *
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.
     */
    public val quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = builder.quietTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSettingsResource(")
        append("applicationId=$applicationId,")
        append("campaignHook=$campaignHook,")
        append("journeyLimits=$journeyLimits,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("limits=$limits,")
        append("quietTime=$quietTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (campaignHook?.hashCode() ?: 0)
        result = 31 * result + (journeyLimits?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (quietTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSettingsResource

        if (applicationId != other.applicationId) return false
        if (campaignHook != other.campaignHook) return false
        if (journeyLimits != other.journeyLimits) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (limits != other.limits) return false
        if (quietTime != other.quietTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application. This identifier is displayed as the **Project ID** on the Amazon Pinpoint console.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.
         */
        public var campaignHook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = null
        /**
         * The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.
         */
        public var journeyLimits: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits? = null
        /**
         * The date and time, in ISO 8601 format, when the application's settings were last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The default sending limits for campaigns in the application.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = null
        /**
         * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't sent to endpoints, if all the following conditions are met:
         * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
         * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
         *
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.
         */
        public var quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsResource) : this() {
            this.applicationId = x.applicationId
            this.campaignHook = x.campaignHook
            this.journeyLimits = x.journeyLimits
            this.lastModifiedDate = x.lastModifiedDate
            this.limits = x.limits
            this.quietTime = x.quietTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsResource = ApplicationSettingsResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignHook] inside the given [block]
         */
        public fun campaignHook(block: aws.sdk.kotlin.services.pinpoint.model.CampaignHook.Builder.() -> kotlin.Unit) {
            this.campaignHook = aws.sdk.kotlin.services.pinpoint.model.CampaignHook.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits] inside the given [block]
         */
        public fun journeyLimits(block: aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits.Builder.() -> kotlin.Unit) {
            this.journeyLimits = aws.sdk.kotlin.services.pinpoint.model.ApplicationSettingsJourneyLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.QuietTime] inside the given [block]
         */
        public fun quietTime(block: aws.sdk.kotlin.services.pinpoint.model.QuietTime.Builder.() -> kotlin.Unit) {
            this.quietTime = aws.sdk.kotlin.services.pinpoint.model.QuietTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
