// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about an activity that was performed by a campaign.
 */
public class ActivityResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the campaign applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The unique identifier for the campaign that the activity applies to.
     */
    public val campaignId: kotlin.String? = builder.campaignId
    /**
     * The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
     */
    public val end: kotlin.String? = builder.end
    /**
     * A JSON object that contains metrics relating to the campaign execution for this campaign activity. For information about the structure and contents of the results, see [Standard Amazon Pinpoint analytics metrics](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public val executionMetrics: Map<String, String>? = builder.executionMetrics
    /**
     * The unique identifier for the activity.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
     */
    public val result: kotlin.String? = builder.result
    /**
     * The scheduled start time, in ISO 8601 format, for the activity.
     */
    public val scheduledStart: kotlin.String? = builder.scheduledStart
    /**
     * The actual start time, in ISO 8601 format, of the activity.
     */
    public val start: kotlin.String? = builder.start
    /**
     * The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, and COMPLETED.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The total number of endpoints that the campaign successfully delivered messages to.
     */
    public val successfulEndpointCount: kotlin.Int? = builder.successfulEndpointCount
    /**
     * The total number of time zones that were completed.
     */
    public val timezonesCompletedCount: kotlin.Int? = builder.timezonesCompletedCount
    /**
     * The total number of unique time zones that are in the segment for the campaign.
     */
    public val timezonesTotalCount: kotlin.Int? = builder.timezonesTotalCount
    /**
     * The total number of endpoints that the campaign attempted to deliver messages to.
     */
    public val totalEndpointCount: kotlin.Int? = builder.totalEndpointCount
    /**
     * The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation of a campaign that's used for A/B testing of a campaign.
     */
    public val treatmentId: kotlin.String? = builder.treatmentId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ActivityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityResponse(")
        append("applicationId=$applicationId,")
        append("campaignId=$campaignId,")
        append("end=$end,")
        append("executionMetrics=$executionMetrics,")
        append("id=$id,")
        append("result=$result,")
        append("scheduledStart=$scheduledStart,")
        append("start=$start,")
        append("state=$state,")
        append("successfulEndpointCount=$successfulEndpointCount,")
        append("timezonesCompletedCount=$timezonesCompletedCount,")
        append("timezonesTotalCount=$timezonesTotalCount,")
        append("totalEndpointCount=$totalEndpointCount,")
        append("treatmentId=$treatmentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (campaignId?.hashCode() ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (executionMetrics?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (scheduledStart?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (successfulEndpointCount ?: 0)
        result = 31 * result + (timezonesCompletedCount ?: 0)
        result = 31 * result + (timezonesTotalCount ?: 0)
        result = 31 * result + (totalEndpointCount ?: 0)
        result = 31 * result + (treatmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityResponse

        if (applicationId != other.applicationId) return false
        if (campaignId != other.campaignId) return false
        if (end != other.end) return false
        if (executionMetrics != other.executionMetrics) return false
        if (id != other.id) return false
        if (result != other.result) return false
        if (scheduledStart != other.scheduledStart) return false
        if (start != other.start) return false
        if (state != other.state) return false
        if (successfulEndpointCount != other.successfulEndpointCount) return false
        if (timezonesCompletedCount != other.timezonesCompletedCount) return false
        if (timezonesTotalCount != other.timezonesTotalCount) return false
        if (totalEndpointCount != other.totalEndpointCount) return false
        if (treatmentId != other.treatmentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ActivityResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the application that the campaign applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The unique identifier for the campaign that the activity applies to.
         */
        public var campaignId: kotlin.String? = null
        /**
         * The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
         */
        public var end: kotlin.String? = null
        /**
         * A JSON object that contains metrics relating to the campaign execution for this campaign activity. For information about the structure and contents of the results, see [Standard Amazon Pinpoint analytics metrics](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html) in the *Amazon Pinpoint Developer Guide*.
         */
        public var executionMetrics: Map<String, String>? = null
        /**
         * The unique identifier for the activity.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
         */
        public var result: kotlin.String? = null
        /**
         * The scheduled start time, in ISO 8601 format, for the activity.
         */
        public var scheduledStart: kotlin.String? = null
        /**
         * The actual start time, in ISO 8601 format, of the activity.
         */
        public var start: kotlin.String? = null
        /**
         * The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, and COMPLETED.
         */
        public var state: kotlin.String? = null
        /**
         * The total number of endpoints that the campaign successfully delivered messages to.
         */
        public var successfulEndpointCount: kotlin.Int? = null
        /**
         * The total number of time zones that were completed.
         */
        public var timezonesCompletedCount: kotlin.Int? = null
        /**
         * The total number of unique time zones that are in the segment for the campaign.
         */
        public var timezonesTotalCount: kotlin.Int? = null
        /**
         * The total number of endpoints that the campaign attempted to deliver messages to.
         */
        public var totalEndpointCount: kotlin.Int? = null
        /**
         * The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation of a campaign that's used for A/B testing of a campaign.
         */
        public var treatmentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ActivityResponse) : this() {
            this.applicationId = x.applicationId
            this.campaignId = x.campaignId
            this.end = x.end
            this.executionMetrics = x.executionMetrics
            this.id = x.id
            this.result = x.result
            this.scheduledStart = x.scheduledStart
            this.start = x.start
            this.state = x.state
            this.successfulEndpointCount = x.successfulEndpointCount
            this.timezonesCompletedCount = x.timezonesCompletedCount
            this.timezonesTotalCount = x.timezonesTotalCount
            this.totalEndpointCount = x.totalEndpointCount
            this.treatmentId = x.treatmentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ActivityResponse = ActivityResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
