// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.pinpoint.auth.DefaultPinpointAuthSchemeProvider
import aws.sdk.kotlin.services.pinpoint.auth.PinpointAuthSchemeProvider
import aws.sdk.kotlin.services.pinpoint.endpoints.DefaultPinpointEndpointProvider
import aws.sdk.kotlin.services.pinpoint.endpoints.PinpointEndpointParameters
import aws.sdk.kotlin.services.pinpoint.endpoints.PinpointEndpointProvider
import aws.sdk.kotlin.services.pinpoint.model.CreateAppRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateAppResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateCampaignResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateEmailTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateExportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateExportJobResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateImportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateImportJobResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateInAppTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateJourneyResponse
import aws.sdk.kotlin.services.pinpoint.model.CreatePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreatePushTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateSegmentResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateSmsTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.CreateVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateVoiceTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteAdmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteAppRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteAppResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteBaiduChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteCampaignResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEndpointResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEventStreamResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteGcmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteInAppTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteJourneyResponse
import aws.sdk.kotlin.services.pinpoint.model.DeletePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeletePushTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteRecommenderConfigurationResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSegmentResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteUserEndpointsRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteUserEndpointsResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.GetAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAdmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetAppRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAppResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationDateRangeKpiResponse
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationSettingsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationSettingsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetAppsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAppsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetBaiduChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignActivitiesRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignActivitiesResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignDateRangeKpiResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetChannelsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetChannelsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEmailChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEmailTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.GetEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEndpointResponse
import aws.sdk.kotlin.services.pinpoint.model.GetEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEventStreamResponse
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobResponse
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetGcmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobResponse
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetInAppMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.GetInAppMessagesResponse
import aws.sdk.kotlin.services.pinpoint.model.GetInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetInAppTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyDateRangeKpiResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionMetricsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunExecutionMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunExecutionMetricsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRunsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetPushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetPushTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationResponse
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentExportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentExportJobsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentImportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentImportJobsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSmsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSmsTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.GetUserEndpointsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetUserEndpointsResponse
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.ListJourneysRequest
import aws.sdk.kotlin.services.pinpoint.model.ListJourneysResponse
import aws.sdk.kotlin.services.pinpoint.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.pinpoint.model.ListTemplateVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTemplateVersionsResponse
import aws.sdk.kotlin.services.pinpoint.model.ListTemplatesRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTemplatesResponse
import aws.sdk.kotlin.services.pinpoint.model.PhoneNumberValidateRequest
import aws.sdk.kotlin.services.pinpoint.model.PhoneNumberValidateResponse
import aws.sdk.kotlin.services.pinpoint.model.PutEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.PutEventStreamResponse
import aws.sdk.kotlin.services.pinpoint.model.PutEventsRequest
import aws.sdk.kotlin.services.pinpoint.model.PutEventsResponse
import aws.sdk.kotlin.services.pinpoint.model.RemoveAttributesRequest
import aws.sdk.kotlin.services.pinpoint.model.RemoveAttributesResponse
import aws.sdk.kotlin.services.pinpoint.model.SendMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.SendMessagesResponse
import aws.sdk.kotlin.services.pinpoint.model.SendOtpMessageRequest
import aws.sdk.kotlin.services.pinpoint.model.SendOtpMessageResponse
import aws.sdk.kotlin.services.pinpoint.model.SendUsersMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.SendUsersMessagesResponse
import aws.sdk.kotlin.services.pinpoint.model.TagResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.TagResourceResponse
import aws.sdk.kotlin.services.pinpoint.model.UntagResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.UntagResourceResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateAdmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateApplicationSettingsRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApplicationSettingsResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateBaiduChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateCampaignResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointsBatchRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointsBatchResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateGcmChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateInAppTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyStateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyStateResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateRecommenderConfigurationResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSegmentResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateTemplateActiveVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateTemplateActiveVersionResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceTemplateResponse
import aws.sdk.kotlin.services.pinpoint.model.VerifyOtpMessageRequest
import aws.sdk.kotlin.services.pinpoint.model.VerifyOtpMessageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Pinpoint"
public const val SdkVersion: String = "1.2.20"
public const val ServiceApiVersion: String = "2016-12-01"

/**
 * Doc Engage API - Amazon Pinpoint API
 */
public interface PinpointClient : SdkClient {
    /**
     * PinpointClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, PinpointClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Pinpoint",
                "PINPOINT",
                "pinpoint",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, PinpointClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): PinpointClient = DefaultPinpointClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: PinpointEndpointProvider = builder.endpointProvider ?: DefaultPinpointEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: PinpointAuthSchemeProvider = builder.authSchemeProvider ?: DefaultPinpointAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Pinpoint"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: PinpointEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: PinpointAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an application.
     */
    public suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     */
    public suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Creates a message template for messages that are sent through the email channel.
     */
    public suspend fun createEmailTemplate(input: CreateEmailTemplateRequest): CreateEmailTemplateResponse

    /**
     * Creates an export job for an application.
     */
    public suspend fun createExportJob(input: CreateExportJobRequest): CreateExportJobResponse

    /**
     * Creates an import job for an application.
     */
    public suspend fun createImportJob(input: CreateImportJobRequest): CreateImportJobResponse

    /**
     * Creates a new message template for messages using the in-app message channel.
     */
    public suspend fun createInAppTemplate(input: CreateInAppTemplateRequest): CreateInAppTemplateResponse

    /**
     * Creates a journey for an application.
     */
    public suspend fun createJourney(input: CreateJourneyRequest): CreateJourneyResponse

    /**
     * Creates a message template for messages that are sent through a push notification channel.
     */
    public suspend fun createPushTemplate(input: CreatePushTemplateRequest): CreatePushTemplateResponse

    /**
     * Creates an Amazon Pinpoint configuration for a recommender model.
     */
    public suspend fun createRecommenderConfiguration(input: CreateRecommenderConfigurationRequest): CreateRecommenderConfigurationResponse

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    public suspend fun createSegment(input: CreateSegmentRequest): CreateSegmentResponse

    /**
     * Creates a message template for messages that are sent through the SMS channel.
     */
    public suspend fun createSmsTemplate(input: CreateSmsTemplateRequest): CreateSmsTemplateResponse

    /**
     * Creates a message template for messages that are sent through the voice channel.
     */
    public suspend fun createVoiceTemplate(input: CreateVoiceTemplateRequest): CreateVoiceTemplateResponse

    /**
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteAdmChannel(input: DeleteAdmChannelRequest): DeleteAdmChannelResponse

    /**
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteApnsChannel(input: DeleteApnsChannelRequest): DeleteApnsChannelResponse

    /**
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteApnsSandboxChannel(input: DeleteApnsSandboxChannelRequest): DeleteApnsSandboxChannelResponse

    /**
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteApnsVoipChannel(input: DeleteApnsVoipChannelRequest): DeleteApnsVoipChannelResponse

    /**
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteApnsVoipSandboxChannel(input: DeleteApnsVoipSandboxChannelRequest): DeleteApnsVoipSandboxChannelResponse

    /**
     * Deletes an application.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteBaiduChannel(input: DeleteBaiduChannelRequest): DeleteBaiduChannelResponse

    /**
     * Deletes a campaign from an application.
     */
    public suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Disables the email channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteEmailChannel(input: DeleteEmailChannelRequest): DeleteEmailChannelResponse

    /**
     * Deletes a message template for messages that were sent through the email channel.
     */
    public suspend fun deleteEmailTemplate(input: DeleteEmailTemplateRequest): DeleteEmailTemplateResponse

    /**
     * Deletes an endpoint from an application.
     */
    public suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes the event stream for an application.
     */
    public suspend fun deleteEventStream(input: DeleteEventStreamRequest): DeleteEventStreamResponse

    /**
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteGcmChannel(input: DeleteGcmChannelRequest): DeleteGcmChannelResponse

    /**
     * Deletes a message template for messages sent using the in-app message channel.
     */
    public suspend fun deleteInAppTemplate(input: DeleteInAppTemplateRequest): DeleteInAppTemplateResponse

    /**
     * Deletes a journey from an application.
     */
    public suspend fun deleteJourney(input: DeleteJourneyRequest): DeleteJourneyResponse

    /**
     * Deletes a message template for messages that were sent through a push notification channel.
     */
    public suspend fun deletePushTemplate(input: DeletePushTemplateRequest): DeletePushTemplateResponse

    /**
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     */
    public suspend fun deleteRecommenderConfiguration(input: DeleteRecommenderConfigurationRequest): DeleteRecommenderConfigurationResponse

    /**
     * Deletes a segment from an application.
     */
    public suspend fun deleteSegment(input: DeleteSegmentRequest): DeleteSegmentResponse

    /**
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteSmsChannel(input: DeleteSmsChannelRequest): DeleteSmsChannelResponse

    /**
     * Deletes a message template for messages that were sent through the SMS channel.
     */
    public suspend fun deleteSmsTemplate(input: DeleteSmsTemplateRequest): DeleteSmsTemplateResponse

    /**
     * Deletes all the endpoints that are associated with a specific user ID.
     */
    public suspend fun deleteUserEndpoints(input: DeleteUserEndpointsRequest): DeleteUserEndpointsResponse

    /**
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     */
    public suspend fun deleteVoiceChannel(input: DeleteVoiceChannelRequest): DeleteVoiceChannelResponse

    /**
     * Deletes a message template for messages that were sent through the voice channel.
     */
    public suspend fun deleteVoiceTemplate(input: DeleteVoiceTemplateRequest): DeleteVoiceTemplateResponse

    /**
     * Retrieves information about the status and settings of the ADM channel for an application.
     */
    public suspend fun getAdmChannel(input: GetAdmChannelRequest): GetAdmChannelResponse

    /**
     * Retrieves information about the status and settings of the APNs channel for an application.
     */
    public suspend fun getApnsChannel(input: GetApnsChannelRequest): GetApnsChannelResponse

    /**
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     */
    public suspend fun getApnsSandboxChannel(input: GetApnsSandboxChannelRequest): GetApnsSandboxChannelResponse

    /**
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     */
    public suspend fun getApnsVoipChannel(input: GetApnsVoipChannelRequest): GetApnsVoipChannelResponse

    /**
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     */
    public suspend fun getApnsVoipSandboxChannel(input: GetApnsVoipSandboxChannelRequest): GetApnsVoipSandboxChannelResponse

    /**
     * Retrieves information about an application.
     */
    public suspend fun getApp(input: GetAppRequest): GetAppResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     */
    public suspend fun getApplicationDateRangeKpi(input: GetApplicationDateRangeKpiRequest): GetApplicationDateRangeKpiResponse

    /**
     * Retrieves information about the settings for an application.
     */
    public suspend fun getApplicationSettings(input: GetApplicationSettingsRequest): GetApplicationSettingsResponse

    /**
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     */
    public suspend fun getApps(input: GetAppsRequest = GetAppsRequest { }): GetAppsResponse

    /**
     * Retrieves information about the status and settings of the Baidu channel for an application.
     */
    public suspend fun getBaiduChannel(input: GetBaiduChannelRequest): GetBaiduChannelResponse

    /**
     * Retrieves information about the status, configuration, and other settings for a campaign.
     */
    public suspend fun getCampaign(input: GetCampaignRequest): GetCampaignResponse

    /**
     * Retrieves information about all the activities for a campaign.
     */
    public suspend fun getCampaignActivities(input: GetCampaignActivitiesRequest): GetCampaignActivitiesResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     */
    public suspend fun getCampaignDateRangeKpi(input: GetCampaignDateRangeKpiRequest): GetCampaignDateRangeKpiResponse

    /**
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     */
    public suspend fun getCampaignVersion(input: GetCampaignVersionRequest): GetCampaignVersionResponse

    /**
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     */
    public suspend fun getCampaignVersions(input: GetCampaignVersionsRequest): GetCampaignVersionsResponse

    /**
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.
     */
    public suspend fun getCampaigns(input: GetCampaignsRequest): GetCampaignsResponse

    /**
     * Retrieves information about the history and status of each channel for an application.
     */
    public suspend fun getChannels(input: GetChannelsRequest): GetChannelsResponse

    /**
     * Retrieves information about the status and settings of the email channel for an application.
     */
    public suspend fun getEmailChannel(input: GetEmailChannelRequest): GetEmailChannelResponse

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     */
    public suspend fun getEmailTemplate(input: GetEmailTemplateRequest): GetEmailTemplateResponse

    /**
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     */
    public suspend fun getEndpoint(input: GetEndpointRequest): GetEndpointResponse

    /**
     * Retrieves information about the event stream settings for an application.
     */
    public suspend fun getEventStream(input: GetEventStreamRequest): GetEventStreamResponse

    /**
     * Retrieves information about the status and settings of a specific export job for an application.
     */
    public suspend fun getExportJob(input: GetExportJobRequest): GetExportJobResponse

    /**
     * Retrieves information about the status and settings of all the export jobs for an application.
     */
    public suspend fun getExportJobs(input: GetExportJobsRequest): GetExportJobsResponse

    /**
     * Retrieves information about the status and settings of the GCM channel for an application.
     */
    public suspend fun getGcmChannel(input: GetGcmChannelRequest): GetGcmChannelResponse

    /**
     * Retrieves information about the status and settings of a specific import job for an application.
     */
    public suspend fun getImportJob(input: GetImportJobRequest): GetImportJobResponse

    /**
     * Retrieves information about the status and settings of all the import jobs for an application.
     */
    public suspend fun getImportJobs(input: GetImportJobsRequest): GetImportJobsResponse

    /**
     * Retrieves the in-app messages targeted for the provided endpoint ID.
     */
    public suspend fun getInAppMessages(input: GetInAppMessagesRequest): GetInAppMessagesResponse

    /**
     * Retrieves the content and settings of a message template for messages sent through the in-app channel.
     */
    public suspend fun getInAppTemplate(input: GetInAppTemplateRequest): GetInAppTemplateResponse

    /**
     * Retrieves information about the status, configuration, and other settings for a journey.
     */
    public suspend fun getJourney(input: GetJourneyRequest): GetJourneyResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     */
    public suspend fun getJourneyDateRangeKpi(input: GetJourneyDateRangeKpiRequest): GetJourneyDateRangeKpiResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     */
    public suspend fun getJourneyExecutionActivityMetrics(input: GetJourneyExecutionActivityMetricsRequest): GetJourneyExecutionActivityMetricsResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     */
    public suspend fun getJourneyExecutionMetrics(input: GetJourneyExecutionMetricsRequest): GetJourneyExecutionMetricsResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.
     *
     * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRunExecutionActivityMetrics.sample
     */
    public suspend fun getJourneyRunExecutionActivityMetrics(input: GetJourneyRunExecutionActivityMetricsRequest): GetJourneyRunExecutionActivityMetricsResponse

    /**
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.
     *
     * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRunExecutionMetrics.sample
     */
    public suspend fun getJourneyRunExecutionMetrics(input: GetJourneyRunExecutionMetricsRequest): GetJourneyRunExecutionMetricsResponse

    /**
     * Provides information about the runs of a journey.
     *
     * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRuns.sample
     */
    public suspend fun getJourneyRuns(input: GetJourneyRunsRequest): GetJourneyRunsResponse

    /**
     * Retrieves the content and settings of a message template for messages that are sent through a push notification channel.
     */
    public suspend fun getPushTemplate(input: GetPushTemplateRequest): GetPushTemplateResponse

    /**
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     */
    public suspend fun getRecommenderConfiguration(input: GetRecommenderConfigurationRequest): GetRecommenderConfigurationResponse

    /**
     * Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.
     */
    public suspend fun getRecommenderConfigurations(input: GetRecommenderConfigurationsRequest = GetRecommenderConfigurationsRequest { }): GetRecommenderConfigurationsResponse

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.
     */
    public suspend fun getSegment(input: GetSegmentRequest): GetSegmentResponse

    /**
     * Retrieves information about the status and settings of the export jobs for a segment.
     */
    public suspend fun getSegmentExportJobs(input: GetSegmentExportJobsRequest): GetSegmentExportJobsResponse

    /**
     * Retrieves information about the status and settings of the import jobs for a segment.
     */
    public suspend fun getSegmentImportJobs(input: GetSegmentImportJobsRequest): GetSegmentImportJobsResponse

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.
     */
    public suspend fun getSegmentVersion(input: GetSegmentVersionRequest): GetSegmentVersionResponse

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.
     */
    public suspend fun getSegmentVersions(input: GetSegmentVersionsRequest): GetSegmentVersionsResponse

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.
     */
    public suspend fun getSegments(input: GetSegmentsRequest): GetSegmentsResponse

    /**
     * Retrieves information about the status and settings of the SMS channel for an application.
     */
    public suspend fun getSmsChannel(input: GetSmsChannelRequest): GetSmsChannelResponse

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     */
    public suspend fun getSmsTemplate(input: GetSmsTemplateRequest): GetSmsTemplateResponse

    /**
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     */
    public suspend fun getUserEndpoints(input: GetUserEndpointsRequest): GetUserEndpointsResponse

    /**
     * Retrieves information about the status and settings of the voice channel for an application.
     */
    public suspend fun getVoiceChannel(input: GetVoiceChannelRequest): GetVoiceChannelResponse

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     */
    public suspend fun getVoiceTemplate(input: GetVoiceTemplateRequest): GetVoiceTemplateResponse

    /**
     * Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.
     */
    public suspend fun listJourneys(input: ListJourneysRequest): ListJourneysResponse

    /**
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves information about all the versions of a specific message template.
     */
    public suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse

    /**
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest = ListTemplatesRequest { }): ListTemplatesResponse

    /**
     * Retrieves information about a phone number.
     */
    public suspend fun phoneNumberValidate(input: PhoneNumberValidateRequest): PhoneNumberValidateResponse

    /**
     * Creates a new event stream for an application or updates the settings of an existing event stream for an application.
     */
    public suspend fun putEventStream(input: PutEventStreamRequest): PutEventStreamResponse

    /**
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.
     */
    public suspend fun putEvents(input: PutEventsRequest): PutEventsResponse

    /**
     * Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.
     */
    public suspend fun removeAttributes(input: RemoveAttributesRequest): RemoveAttributesResponse

    /**
     * Creates and sends a direct message.
     */
    public suspend fun sendMessages(input: SendMessagesRequest): SendMessagesResponse

    /**
     * Send an OTP message
     */
    public suspend fun sendOtpMessage(input: SendOtpMessageRequest): SendOtpMessageResponse

    /**
     * Creates and sends a message to a list of users.
     */
    public suspend fun sendUsersMessages(input: SendUsersMessagesRequest): SendUsersMessagesResponse

    /**
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.
     */
    public suspend fun updateAdmChannel(input: UpdateAdmChannelRequest): UpdateAdmChannelResponse

    /**
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.
     */
    public suspend fun updateApnsChannel(input: UpdateApnsChannelRequest): UpdateApnsChannelResponse

    /**
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.
     */
    public suspend fun updateApnsSandboxChannel(input: UpdateApnsSandboxChannelRequest): UpdateApnsSandboxChannelResponse

    /**
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.
     */
    public suspend fun updateApnsVoipChannel(input: UpdateApnsVoipChannelRequest): UpdateApnsVoipChannelResponse

    /**
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.
     */
    public suspend fun updateApnsVoipSandboxChannel(input: UpdateApnsVoipSandboxChannelRequest): UpdateApnsVoipSandboxChannelResponse

    /**
     * Updates the settings for an application.
     */
    public suspend fun updateApplicationSettings(input: UpdateApplicationSettingsRequest): UpdateApplicationSettingsResponse

    /**
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.
     */
    public suspend fun updateBaiduChannel(input: UpdateBaiduChannelRequest): UpdateBaiduChannelResponse

    /**
     * Updates the configuration and other settings for a campaign.
     */
    public suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse

    /**
     * Enables the email channel for an application or updates the status and settings of the email channel for an application.
     */
    public suspend fun updateEmailChannel(input: UpdateEmailChannelRequest): UpdateEmailChannelResponse

    /**
     * Updates an existing message template for messages that are sent through the email channel.
     */
    public suspend fun updateEmailTemplate(input: UpdateEmailTemplateRequest): UpdateEmailTemplateResponse

    /**
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    public suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse

    /**
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    public suspend fun updateEndpointsBatch(input: UpdateEndpointsBatchRequest): UpdateEndpointsBatchResponse

    /**
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.
     */
    public suspend fun updateGcmChannel(input: UpdateGcmChannelRequest): UpdateGcmChannelResponse

    /**
     * Updates an existing message template for messages sent through the in-app message channel.
     */
    public suspend fun updateInAppTemplate(input: UpdateInAppTemplateRequest): UpdateInAppTemplateResponse

    /**
     * Updates the configuration and other settings for a journey.
     */
    public suspend fun updateJourney(input: UpdateJourneyRequest): UpdateJourneyResponse

    /**
     * Cancels (stops) an active journey.
     */
    public suspend fun updateJourneyState(input: UpdateJourneyStateRequest): UpdateJourneyStateResponse

    /**
     * Updates an existing message template for messages that are sent through a push notification channel.
     */
    public suspend fun updatePushTemplate(input: UpdatePushTemplateRequest): UpdatePushTemplateResponse

    /**
     * Updates an Amazon Pinpoint configuration for a recommender model.
     */
    public suspend fun updateRecommenderConfiguration(input: UpdateRecommenderConfigurationRequest): UpdateRecommenderConfigurationResponse

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    public suspend fun updateSegment(input: UpdateSegmentRequest): UpdateSegmentResponse

    /**
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.
     */
    public suspend fun updateSmsChannel(input: UpdateSmsChannelRequest): UpdateSmsChannelResponse

    /**
     * Updates an existing message template for messages that are sent through the SMS channel.
     */
    public suspend fun updateSmsTemplate(input: UpdateSmsTemplateRequest): UpdateSmsTemplateResponse

    /**
     * Changes the status of a specific version of a message template to *active*.
     */
    public suspend fun updateTemplateActiveVersion(input: UpdateTemplateActiveVersionRequest): UpdateTemplateActiveVersionResponse

    /**
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an application.
     */
    public suspend fun updateVoiceChannel(input: UpdateVoiceChannelRequest): UpdateVoiceChannelResponse

    /**
     * Updates an existing message template for messages that are sent through the voice channel.
     */
    public suspend fun updateVoiceTemplate(input: UpdateVoiceTemplateRequest): UpdateVoiceTemplateResponse

    /**
     * Verify an OTP
     */
    public suspend fun verifyOtpMessage(input: VerifyOtpMessageRequest): VerifyOtpMessageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun PinpointClient.withConfig(block: PinpointClient.Config.Builder.() -> Unit): PinpointClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultPinpointClient(newConfig)
}

/**
 * Creates an application.
 */
public suspend inline fun PinpointClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
 */
public suspend inline fun PinpointClient.createCampaign(crossinline block: CreateCampaignRequest.Builder.() -> Unit): CreateCampaignResponse = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

/**
 * Creates a message template for messages that are sent through the email channel.
 */
public suspend inline fun PinpointClient.createEmailTemplate(crossinline block: CreateEmailTemplateRequest.Builder.() -> Unit): CreateEmailTemplateResponse = createEmailTemplate(CreateEmailTemplateRequest.Builder().apply(block).build())

/**
 * Creates an export job for an application.
 */
public suspend inline fun PinpointClient.createExportJob(crossinline block: CreateExportJobRequest.Builder.() -> Unit): CreateExportJobResponse = createExportJob(CreateExportJobRequest.Builder().apply(block).build())

/**
 * Creates an import job for an application.
 */
public suspend inline fun PinpointClient.createImportJob(crossinline block: CreateImportJobRequest.Builder.() -> Unit): CreateImportJobResponse = createImportJob(CreateImportJobRequest.Builder().apply(block).build())

/**
 * Creates a new message template for messages using the in-app message channel.
 */
public suspend inline fun PinpointClient.createInAppTemplate(crossinline block: CreateInAppTemplateRequest.Builder.() -> Unit): CreateInAppTemplateResponse = createInAppTemplate(CreateInAppTemplateRequest.Builder().apply(block).build())

/**
 * Creates a journey for an application.
 */
public suspend inline fun PinpointClient.createJourney(crossinline block: CreateJourneyRequest.Builder.() -> Unit): CreateJourneyResponse = createJourney(CreateJourneyRequest.Builder().apply(block).build())

/**
 * Creates a message template for messages that are sent through a push notification channel.
 */
public suspend inline fun PinpointClient.createPushTemplate(crossinline block: CreatePushTemplateRequest.Builder.() -> Unit): CreatePushTemplateResponse = createPushTemplate(CreatePushTemplateRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Pinpoint configuration for a recommender model.
 */
public suspend inline fun PinpointClient.createRecommenderConfiguration(crossinline block: CreateRecommenderConfigurationRequest.Builder.() -> Unit): CreateRecommenderConfigurationResponse = createRecommenderConfiguration(CreateRecommenderConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
 */
public suspend inline fun PinpointClient.createSegment(crossinline block: CreateSegmentRequest.Builder.() -> Unit): CreateSegmentResponse = createSegment(CreateSegmentRequest.Builder().apply(block).build())

/**
 * Creates a message template for messages that are sent through the SMS channel.
 */
public suspend inline fun PinpointClient.createSmsTemplate(crossinline block: CreateSmsTemplateRequest.Builder.() -> Unit): CreateSmsTemplateResponse = createSmsTemplate(CreateSmsTemplateRequest.Builder().apply(block).build())

/**
 * Creates a message template for messages that are sent through the voice channel.
 */
public suspend inline fun PinpointClient.createVoiceTemplate(crossinline block: CreateVoiceTemplateRequest.Builder.() -> Unit): CreateVoiceTemplateResponse = createVoiceTemplate(CreateVoiceTemplateRequest.Builder().apply(block).build())

/**
 * Disables the ADM channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteAdmChannel(crossinline block: DeleteAdmChannelRequest.Builder.() -> Unit): DeleteAdmChannelResponse = deleteAdmChannel(DeleteAdmChannelRequest.Builder().apply(block).build())

/**
 * Disables the APNs channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteApnsChannel(crossinline block: DeleteApnsChannelRequest.Builder.() -> Unit): DeleteApnsChannelResponse = deleteApnsChannel(DeleteApnsChannelRequest.Builder().apply(block).build())

/**
 * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteApnsSandboxChannel(crossinline block: DeleteApnsSandboxChannelRequest.Builder.() -> Unit): DeleteApnsSandboxChannelResponse = deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest.Builder().apply(block).build())

/**
 * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteApnsVoipChannel(crossinline block: DeleteApnsVoipChannelRequest.Builder.() -> Unit): DeleteApnsVoipChannelResponse = deleteApnsVoipChannel(DeleteApnsVoipChannelRequest.Builder().apply(block).build())

/**
 * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteApnsVoipSandboxChannel(crossinline block: DeleteApnsVoipSandboxChannelRequest.Builder.() -> Unit): DeleteApnsVoipSandboxChannelResponse = deleteApnsVoipSandboxChannel(DeleteApnsVoipSandboxChannelRequest.Builder().apply(block).build())

/**
 * Deletes an application.
 */
public suspend inline fun PinpointClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Disables the Baidu channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteBaiduChannel(crossinline block: DeleteBaiduChannelRequest.Builder.() -> Unit): DeleteBaiduChannelResponse = deleteBaiduChannel(DeleteBaiduChannelRequest.Builder().apply(block).build())

/**
 * Deletes a campaign from an application.
 */
public suspend inline fun PinpointClient.deleteCampaign(crossinline block: DeleteCampaignRequest.Builder.() -> Unit): DeleteCampaignResponse = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

/**
 * Disables the email channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteEmailChannel(crossinline block: DeleteEmailChannelRequest.Builder.() -> Unit): DeleteEmailChannelResponse = deleteEmailChannel(DeleteEmailChannelRequest.Builder().apply(block).build())

/**
 * Deletes a message template for messages that were sent through the email channel.
 */
public suspend inline fun PinpointClient.deleteEmailTemplate(crossinline block: DeleteEmailTemplateRequest.Builder.() -> Unit): DeleteEmailTemplateResponse = deleteEmailTemplate(DeleteEmailTemplateRequest.Builder().apply(block).build())

/**
 * Deletes an endpoint from an application.
 */
public suspend inline fun PinpointClient.deleteEndpoint(crossinline block: DeleteEndpointRequest.Builder.() -> Unit): DeleteEndpointResponse = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

/**
 * Deletes the event stream for an application.
 */
public suspend inline fun PinpointClient.deleteEventStream(crossinline block: DeleteEventStreamRequest.Builder.() -> Unit): DeleteEventStreamResponse = deleteEventStream(DeleteEventStreamRequest.Builder().apply(block).build())

/**
 * Disables the GCM channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteGcmChannel(crossinline block: DeleteGcmChannelRequest.Builder.() -> Unit): DeleteGcmChannelResponse = deleteGcmChannel(DeleteGcmChannelRequest.Builder().apply(block).build())

/**
 * Deletes a message template for messages sent using the in-app message channel.
 */
public suspend inline fun PinpointClient.deleteInAppTemplate(crossinline block: DeleteInAppTemplateRequest.Builder.() -> Unit): DeleteInAppTemplateResponse = deleteInAppTemplate(DeleteInAppTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a journey from an application.
 */
public suspend inline fun PinpointClient.deleteJourney(crossinline block: DeleteJourneyRequest.Builder.() -> Unit): DeleteJourneyResponse = deleteJourney(DeleteJourneyRequest.Builder().apply(block).build())

/**
 * Deletes a message template for messages that were sent through a push notification channel.
 */
public suspend inline fun PinpointClient.deletePushTemplate(crossinline block: DeletePushTemplateRequest.Builder.() -> Unit): DeletePushTemplateResponse = deletePushTemplate(DeletePushTemplateRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Pinpoint configuration for a recommender model.
 */
public suspend inline fun PinpointClient.deleteRecommenderConfiguration(crossinline block: DeleteRecommenderConfigurationRequest.Builder.() -> Unit): DeleteRecommenderConfigurationResponse = deleteRecommenderConfiguration(DeleteRecommenderConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a segment from an application.
 */
public suspend inline fun PinpointClient.deleteSegment(crossinline block: DeleteSegmentRequest.Builder.() -> Unit): DeleteSegmentResponse = deleteSegment(DeleteSegmentRequest.Builder().apply(block).build())

/**
 * Disables the SMS channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteSmsChannel(crossinline block: DeleteSmsChannelRequest.Builder.() -> Unit): DeleteSmsChannelResponse = deleteSmsChannel(DeleteSmsChannelRequest.Builder().apply(block).build())

/**
 * Deletes a message template for messages that were sent through the SMS channel.
 */
public suspend inline fun PinpointClient.deleteSmsTemplate(crossinline block: DeleteSmsTemplateRequest.Builder.() -> Unit): DeleteSmsTemplateResponse = deleteSmsTemplate(DeleteSmsTemplateRequest.Builder().apply(block).build())

/**
 * Deletes all the endpoints that are associated with a specific user ID.
 */
public suspend inline fun PinpointClient.deleteUserEndpoints(crossinline block: DeleteUserEndpointsRequest.Builder.() -> Unit): DeleteUserEndpointsResponse = deleteUserEndpoints(DeleteUserEndpointsRequest.Builder().apply(block).build())

/**
 * Disables the voice channel for an application and deletes any existing settings for the channel.
 */
public suspend inline fun PinpointClient.deleteVoiceChannel(crossinline block: DeleteVoiceChannelRequest.Builder.() -> Unit): DeleteVoiceChannelResponse = deleteVoiceChannel(DeleteVoiceChannelRequest.Builder().apply(block).build())

/**
 * Deletes a message template for messages that were sent through the voice channel.
 */
public suspend inline fun PinpointClient.deleteVoiceTemplate(crossinline block: DeleteVoiceTemplateRequest.Builder.() -> Unit): DeleteVoiceTemplateResponse = deleteVoiceTemplate(DeleteVoiceTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the ADM channel for an application.
 */
public suspend inline fun PinpointClient.getAdmChannel(crossinline block: GetAdmChannelRequest.Builder.() -> Unit): GetAdmChannelResponse = getAdmChannel(GetAdmChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the APNs channel for an application.
 */
public suspend inline fun PinpointClient.getApnsChannel(crossinline block: GetApnsChannelRequest.Builder.() -> Unit): GetApnsChannelResponse = getApnsChannel(GetApnsChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the APNs sandbox channel for an application.
 */
public suspend inline fun PinpointClient.getApnsSandboxChannel(crossinline block: GetApnsSandboxChannelRequest.Builder.() -> Unit): GetApnsSandboxChannelResponse = getApnsSandboxChannel(GetApnsSandboxChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the APNs VoIP channel for an application.
 */
public suspend inline fun PinpointClient.getApnsVoipChannel(crossinline block: GetApnsVoipChannelRequest.Builder.() -> Unit): GetApnsVoipChannelResponse = getApnsVoipChannel(GetApnsVoipChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
 */
public suspend inline fun PinpointClient.getApnsVoipSandboxChannel(crossinline block: GetApnsVoipSandboxChannelRequest.Builder.() -> Unit): GetApnsVoipSandboxChannelResponse = getApnsVoipSandboxChannel(GetApnsVoipSandboxChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about an application.
 */
public suspend inline fun PinpointClient.getApp(crossinline block: GetAppRequest.Builder.() -> Unit): GetAppResponse = getApp(GetAppRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
 */
public suspend inline fun PinpointClient.getApplicationDateRangeKpi(crossinline block: GetApplicationDateRangeKpiRequest.Builder.() -> Unit): GetApplicationDateRangeKpiResponse = getApplicationDateRangeKpi(GetApplicationDateRangeKpiRequest.Builder().apply(block).build())

/**
 * Retrieves information about the settings for an application.
 */
public suspend inline fun PinpointClient.getApplicationSettings(crossinline block: GetApplicationSettingsRequest.Builder.() -> Unit): GetApplicationSettingsResponse = getApplicationSettings(GetApplicationSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
 */
public suspend inline fun PinpointClient.getApps(crossinline block: GetAppsRequest.Builder.() -> Unit): GetAppsResponse = getApps(GetAppsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the Baidu channel for an application.
 */
public suspend inline fun PinpointClient.getBaiduChannel(crossinline block: GetBaiduChannelRequest.Builder.() -> Unit): GetBaiduChannelResponse = getBaiduChannel(GetBaiduChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for a campaign.
 */
public suspend inline fun PinpointClient.getCampaign(crossinline block: GetCampaignRequest.Builder.() -> Unit): GetCampaignResponse = getCampaign(GetCampaignRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the activities for a campaign.
 */
public suspend inline fun PinpointClient.getCampaignActivities(crossinline block: GetCampaignActivitiesRequest.Builder.() -> Unit): GetCampaignActivitiesResponse = getCampaignActivities(GetCampaignActivitiesRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
 */
public suspend inline fun PinpointClient.getCampaignDateRangeKpi(crossinline block: GetCampaignDateRangeKpiRequest.Builder.() -> Unit): GetCampaignDateRangeKpiResponse = getCampaignDateRangeKpi(GetCampaignDateRangeKpiRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
 */
public suspend inline fun PinpointClient.getCampaignVersion(crossinline block: GetCampaignVersionRequest.Builder.() -> Unit): GetCampaignVersionResponse = getCampaignVersion(GetCampaignVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
 */
public suspend inline fun PinpointClient.getCampaignVersions(crossinline block: GetCampaignVersionsRequest.Builder.() -> Unit): GetCampaignVersionsResponse = getCampaignVersions(GetCampaignVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.
 */
public suspend inline fun PinpointClient.getCampaigns(crossinline block: GetCampaignsRequest.Builder.() -> Unit): GetCampaignsResponse = getCampaigns(GetCampaignsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the history and status of each channel for an application.
 */
public suspend inline fun PinpointClient.getChannels(crossinline block: GetChannelsRequest.Builder.() -> Unit): GetChannelsResponse = getChannels(GetChannelsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the email channel for an application.
 */
public suspend inline fun PinpointClient.getEmailChannel(crossinline block: GetEmailChannelRequest.Builder.() -> Unit): GetEmailChannelResponse = getEmailChannel(GetEmailChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the content and settings of a message template for messages that are sent through the email channel.
 */
public suspend inline fun PinpointClient.getEmailTemplate(crossinline block: GetEmailTemplateRequest.Builder.() -> Unit): GetEmailTemplateResponse = getEmailTemplate(GetEmailTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about the settings and attributes of a specific endpoint for an application.
 */
public suspend inline fun PinpointClient.getEndpoint(crossinline block: GetEndpointRequest.Builder.() -> Unit): GetEndpointResponse = getEndpoint(GetEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves information about the event stream settings for an application.
 */
public suspend inline fun PinpointClient.getEventStream(crossinline block: GetEventStreamRequest.Builder.() -> Unit): GetEventStreamResponse = getEventStream(GetEventStreamRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of a specific export job for an application.
 */
public suspend inline fun PinpointClient.getExportJob(crossinline block: GetExportJobRequest.Builder.() -> Unit): GetExportJobResponse = getExportJob(GetExportJobRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of all the export jobs for an application.
 */
public suspend inline fun PinpointClient.getExportJobs(crossinline block: GetExportJobsRequest.Builder.() -> Unit): GetExportJobsResponse = getExportJobs(GetExportJobsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the GCM channel for an application.
 */
public suspend inline fun PinpointClient.getGcmChannel(crossinline block: GetGcmChannelRequest.Builder.() -> Unit): GetGcmChannelResponse = getGcmChannel(GetGcmChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of a specific import job for an application.
 */
public suspend inline fun PinpointClient.getImportJob(crossinline block: GetImportJobRequest.Builder.() -> Unit): GetImportJobResponse = getImportJob(GetImportJobRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of all the import jobs for an application.
 */
public suspend inline fun PinpointClient.getImportJobs(crossinline block: GetImportJobsRequest.Builder.() -> Unit): GetImportJobsResponse = getImportJobs(GetImportJobsRequest.Builder().apply(block).build())

/**
 * Retrieves the in-app messages targeted for the provided endpoint ID.
 */
public suspend inline fun PinpointClient.getInAppMessages(crossinline block: GetInAppMessagesRequest.Builder.() -> Unit): GetInAppMessagesResponse = getInAppMessages(GetInAppMessagesRequest.Builder().apply(block).build())

/**
 * Retrieves the content and settings of a message template for messages sent through the in-app channel.
 */
public suspend inline fun PinpointClient.getInAppTemplate(crossinline block: GetInAppTemplateRequest.Builder.() -> Unit): GetInAppTemplateResponse = getInAppTemplate(GetInAppTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for a journey.
 */
public suspend inline fun PinpointClient.getJourney(crossinline block: GetJourneyRequest.Builder.() -> Unit): GetJourneyResponse = getJourney(GetJourneyRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
 */
public suspend inline fun PinpointClient.getJourneyDateRangeKpi(crossinline block: GetJourneyDateRangeKpiRequest.Builder.() -> Unit): GetJourneyDateRangeKpiResponse = getJourneyDateRangeKpi(GetJourneyDateRangeKpiRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
 */
public suspend inline fun PinpointClient.getJourneyExecutionActivityMetrics(crossinline block: GetJourneyExecutionActivityMetricsRequest.Builder.() -> Unit): GetJourneyExecutionActivityMetricsResponse = getJourneyExecutionActivityMetrics(GetJourneyExecutionActivityMetricsRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
 */
public suspend inline fun PinpointClient.getJourneyExecutionMetrics(crossinline block: GetJourneyExecutionMetricsRequest.Builder.() -> Unit): GetJourneyExecutionMetricsResponse = getJourneyExecutionMetrics(GetJourneyExecutionMetricsRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.
 *
 * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRunExecutionActivityMetrics.sample
 */
public suspend inline fun PinpointClient.getJourneyRunExecutionActivityMetrics(crossinline block: GetJourneyRunExecutionActivityMetricsRequest.Builder.() -> Unit): GetJourneyRunExecutionActivityMetricsResponse = getJourneyRunExecutionActivityMetrics(GetJourneyRunExecutionActivityMetricsRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.
 *
 * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRunExecutionMetrics.sample
 */
public suspend inline fun PinpointClient.getJourneyRunExecutionMetrics(crossinline block: GetJourneyRunExecutionMetricsRequest.Builder.() -> Unit): GetJourneyRunExecutionMetricsResponse = getJourneyRunExecutionMetrics(GetJourneyRunExecutionMetricsRequest.Builder().apply(block).build())

/**
 * Provides information about the runs of a journey.
 *
 * @sample aws.sdk.kotlin.services.pinpoint.samples.GetJourneyRuns.sample
 */
public suspend inline fun PinpointClient.getJourneyRuns(crossinline block: GetJourneyRunsRequest.Builder.() -> Unit): GetJourneyRunsResponse = getJourneyRuns(GetJourneyRunsRequest.Builder().apply(block).build())

/**
 * Retrieves the content and settings of a message template for messages that are sent through a push notification channel.
 */
public suspend inline fun PinpointClient.getPushTemplate(crossinline block: GetPushTemplateRequest.Builder.() -> Unit): GetPushTemplateResponse = getPushTemplate(GetPushTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
 */
public suspend inline fun PinpointClient.getRecommenderConfiguration(crossinline block: GetRecommenderConfigurationRequest.Builder.() -> Unit): GetRecommenderConfigurationResponse = getRecommenderConfiguration(GetRecommenderConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.
 */
public suspend inline fun PinpointClient.getRecommenderConfigurations(crossinline block: GetRecommenderConfigurationsRequest.Builder.() -> Unit): GetRecommenderConfigurationsResponse = getRecommenderConfigurations(GetRecommenderConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.
 */
public suspend inline fun PinpointClient.getSegment(crossinline block: GetSegmentRequest.Builder.() -> Unit): GetSegmentResponse = getSegment(GetSegmentRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the export jobs for a segment.
 */
public suspend inline fun PinpointClient.getSegmentExportJobs(crossinline block: GetSegmentExportJobsRequest.Builder.() -> Unit): GetSegmentExportJobsResponse = getSegmentExportJobs(GetSegmentExportJobsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the import jobs for a segment.
 */
public suspend inline fun PinpointClient.getSegmentImportJobs(crossinline block: GetSegmentImportJobsRequest.Builder.() -> Unit): GetSegmentImportJobsResponse = getSegmentImportJobs(GetSegmentImportJobsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.
 */
public suspend inline fun PinpointClient.getSegmentVersion(crossinline block: GetSegmentVersionRequest.Builder.() -> Unit): GetSegmentVersionResponse = getSegmentVersion(GetSegmentVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.
 */
public suspend inline fun PinpointClient.getSegmentVersions(crossinline block: GetSegmentVersionsRequest.Builder.() -> Unit): GetSegmentVersionsResponse = getSegmentVersions(GetSegmentVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.
 */
public suspend inline fun PinpointClient.getSegments(crossinline block: GetSegmentsRequest.Builder.() -> Unit): GetSegmentsResponse = getSegments(GetSegmentsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the SMS channel for an application.
 */
public suspend inline fun PinpointClient.getSmsChannel(crossinline block: GetSmsChannelRequest.Builder.() -> Unit): GetSmsChannelResponse = getSmsChannel(GetSmsChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
 */
public suspend inline fun PinpointClient.getSmsTemplate(crossinline block: GetSmsTemplateRequest.Builder.() -> Unit): GetSmsTemplateResponse = getSmsTemplate(GetSmsTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the endpoints that are associated with a specific user ID.
 */
public suspend inline fun PinpointClient.getUserEndpoints(crossinline block: GetUserEndpointsRequest.Builder.() -> Unit): GetUserEndpointsResponse = getUserEndpoints(GetUserEndpointsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status and settings of the voice channel for an application.
 */
public suspend inline fun PinpointClient.getVoiceChannel(crossinline block: GetVoiceChannelRequest.Builder.() -> Unit): GetVoiceChannelResponse = getVoiceChannel(GetVoiceChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
 */
public suspend inline fun PinpointClient.getVoiceTemplate(crossinline block: GetVoiceTemplateRequest.Builder.() -> Unit): GetVoiceTemplateResponse = getVoiceTemplate(GetVoiceTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.
 */
public suspend inline fun PinpointClient.listJourneys(crossinline block: ListJourneysRequest.Builder.() -> Unit): ListJourneysResponse = listJourneys(ListJourneysRequest.Builder().apply(block).build())

/**
 * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.
 */
public suspend inline fun PinpointClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the versions of a specific message template.
 */
public suspend inline fun PinpointClient.listTemplateVersions(crossinline block: ListTemplateVersionsRequest.Builder.() -> Unit): ListTemplateVersionsResponse = listTemplateVersions(ListTemplateVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
 */
public suspend inline fun PinpointClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * Retrieves information about a phone number.
 */
public suspend inline fun PinpointClient.phoneNumberValidate(crossinline block: PhoneNumberValidateRequest.Builder.() -> Unit): PhoneNumberValidateResponse = phoneNumberValidate(PhoneNumberValidateRequest.Builder().apply(block).build())

/**
 * Creates a new event stream for an application or updates the settings of an existing event stream for an application.
 */
public suspend inline fun PinpointClient.putEventStream(crossinline block: PutEventStreamRequest.Builder.() -> Unit): PutEventStreamResponse = putEventStream(PutEventStreamRequest.Builder().apply(block).build())

/**
 * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.
 */
public suspend inline fun PinpointClient.putEvents(crossinline block: PutEventsRequest.Builder.() -> Unit): PutEventsResponse = putEvents(PutEventsRequest.Builder().apply(block).build())

/**
 * Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.
 */
public suspend inline fun PinpointClient.removeAttributes(crossinline block: RemoveAttributesRequest.Builder.() -> Unit): RemoveAttributesResponse = removeAttributes(RemoveAttributesRequest.Builder().apply(block).build())

/**
 * Creates and sends a direct message.
 */
public suspend inline fun PinpointClient.sendMessages(crossinline block: SendMessagesRequest.Builder.() -> Unit): SendMessagesResponse = sendMessages(SendMessagesRequest.Builder().apply(block).build())

/**
 * Send an OTP message
 */
public suspend inline fun PinpointClient.sendOtpMessage(crossinline block: SendOtpMessageRequest.Builder.() -> Unit): SendOtpMessageResponse = sendOtpMessage(SendOtpMessageRequest.Builder().apply(block).build())

/**
 * Creates and sends a message to a list of users.
 */
public suspend inline fun PinpointClient.sendUsersMessages(crossinline block: SendUsersMessagesRequest.Builder.() -> Unit): SendUsersMessagesResponse = sendUsersMessages(SendUsersMessagesRequest.Builder().apply(block).build())

/**
 * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
 */
public suspend inline fun PinpointClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
 */
public suspend inline fun PinpointClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.
 */
public suspend inline fun PinpointClient.updateAdmChannel(crossinline block: UpdateAdmChannelRequest.Builder.() -> Unit): UpdateAdmChannelResponse = updateAdmChannel(UpdateAdmChannelRequest.Builder().apply(block).build())

/**
 * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.
 */
public suspend inline fun PinpointClient.updateApnsChannel(crossinline block: UpdateApnsChannelRequest.Builder.() -> Unit): UpdateApnsChannelResponse = updateApnsChannel(UpdateApnsChannelRequest.Builder().apply(block).build())

/**
 * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.
 */
public suspend inline fun PinpointClient.updateApnsSandboxChannel(crossinline block: UpdateApnsSandboxChannelRequest.Builder.() -> Unit): UpdateApnsSandboxChannelResponse = updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest.Builder().apply(block).build())

/**
 * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.
 */
public suspend inline fun PinpointClient.updateApnsVoipChannel(crossinline block: UpdateApnsVoipChannelRequest.Builder.() -> Unit): UpdateApnsVoipChannelResponse = updateApnsVoipChannel(UpdateApnsVoipChannelRequest.Builder().apply(block).build())

/**
 * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.
 */
public suspend inline fun PinpointClient.updateApnsVoipSandboxChannel(crossinline block: UpdateApnsVoipSandboxChannelRequest.Builder.() -> Unit): UpdateApnsVoipSandboxChannelResponse = updateApnsVoipSandboxChannel(UpdateApnsVoipSandboxChannelRequest.Builder().apply(block).build())

/**
 * Updates the settings for an application.
 */
public suspend inline fun PinpointClient.updateApplicationSettings(crossinline block: UpdateApplicationSettingsRequest.Builder.() -> Unit): UpdateApplicationSettingsResponse = updateApplicationSettings(UpdateApplicationSettingsRequest.Builder().apply(block).build())

/**
 * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.
 */
public suspend inline fun PinpointClient.updateBaiduChannel(crossinline block: UpdateBaiduChannelRequest.Builder.() -> Unit): UpdateBaiduChannelResponse = updateBaiduChannel(UpdateBaiduChannelRequest.Builder().apply(block).build())

/**
 * Updates the configuration and other settings for a campaign.
 */
public suspend inline fun PinpointClient.updateCampaign(crossinline block: UpdateCampaignRequest.Builder.() -> Unit): UpdateCampaignResponse = updateCampaign(UpdateCampaignRequest.Builder().apply(block).build())

/**
 * Enables the email channel for an application or updates the status and settings of the email channel for an application.
 */
public suspend inline fun PinpointClient.updateEmailChannel(crossinline block: UpdateEmailChannelRequest.Builder.() -> Unit): UpdateEmailChannelResponse = updateEmailChannel(UpdateEmailChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing message template for messages that are sent through the email channel.
 */
public suspend inline fun PinpointClient.updateEmailTemplate(crossinline block: UpdateEmailTemplateRequest.Builder.() -> Unit): UpdateEmailTemplateResponse = updateEmailTemplate(UpdateEmailTemplateRequest.Builder().apply(block).build())

/**
 * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
 */
public suspend inline fun PinpointClient.updateEndpoint(crossinline block: UpdateEndpointRequest.Builder.() -> Unit): UpdateEndpointResponse = updateEndpoint(UpdateEndpointRequest.Builder().apply(block).build())

/**
 * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
 */
public suspend inline fun PinpointClient.updateEndpointsBatch(crossinline block: UpdateEndpointsBatchRequest.Builder.() -> Unit): UpdateEndpointsBatchResponse = updateEndpointsBatch(UpdateEndpointsBatchRequest.Builder().apply(block).build())

/**
 * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.
 */
public suspend inline fun PinpointClient.updateGcmChannel(crossinline block: UpdateGcmChannelRequest.Builder.() -> Unit): UpdateGcmChannelResponse = updateGcmChannel(UpdateGcmChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing message template for messages sent through the in-app message channel.
 */
public suspend inline fun PinpointClient.updateInAppTemplate(crossinline block: UpdateInAppTemplateRequest.Builder.() -> Unit): UpdateInAppTemplateResponse = updateInAppTemplate(UpdateInAppTemplateRequest.Builder().apply(block).build())

/**
 * Updates the configuration and other settings for a journey.
 */
public suspend inline fun PinpointClient.updateJourney(crossinline block: UpdateJourneyRequest.Builder.() -> Unit): UpdateJourneyResponse = updateJourney(UpdateJourneyRequest.Builder().apply(block).build())

/**
 * Cancels (stops) an active journey.
 */
public suspend inline fun PinpointClient.updateJourneyState(crossinline block: UpdateJourneyStateRequest.Builder.() -> Unit): UpdateJourneyStateResponse = updateJourneyState(UpdateJourneyStateRequest.Builder().apply(block).build())

/**
 * Updates an existing message template for messages that are sent through a push notification channel.
 */
public suspend inline fun PinpointClient.updatePushTemplate(crossinline block: UpdatePushTemplateRequest.Builder.() -> Unit): UpdatePushTemplateResponse = updatePushTemplate(UpdatePushTemplateRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Pinpoint configuration for a recommender model.
 */
public suspend inline fun PinpointClient.updateRecommenderConfiguration(crossinline block: UpdateRecommenderConfigurationRequest.Builder.() -> Unit): UpdateRecommenderConfigurationResponse = updateRecommenderConfiguration(UpdateRecommenderConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
 */
public suspend inline fun PinpointClient.updateSegment(crossinline block: UpdateSegmentRequest.Builder.() -> Unit): UpdateSegmentResponse = updateSegment(UpdateSegmentRequest.Builder().apply(block).build())

/**
 * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.
 */
public suspend inline fun PinpointClient.updateSmsChannel(crossinline block: UpdateSmsChannelRequest.Builder.() -> Unit): UpdateSmsChannelResponse = updateSmsChannel(UpdateSmsChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing message template for messages that are sent through the SMS channel.
 */
public suspend inline fun PinpointClient.updateSmsTemplate(crossinline block: UpdateSmsTemplateRequest.Builder.() -> Unit): UpdateSmsTemplateResponse = updateSmsTemplate(UpdateSmsTemplateRequest.Builder().apply(block).build())

/**
 * Changes the status of a specific version of a message template to *active*.
 */
public suspend inline fun PinpointClient.updateTemplateActiveVersion(crossinline block: UpdateTemplateActiveVersionRequest.Builder.() -> Unit): UpdateTemplateActiveVersionResponse = updateTemplateActiveVersion(UpdateTemplateActiveVersionRequest.Builder().apply(block).build())

/**
 * Enables the voice channel for an application or updates the status and settings of the voice channel for an application.
 */
public suspend inline fun PinpointClient.updateVoiceChannel(crossinline block: UpdateVoiceChannelRequest.Builder.() -> Unit): UpdateVoiceChannelResponse = updateVoiceChannel(UpdateVoiceChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing message template for messages that are sent through the voice channel.
 */
public suspend inline fun PinpointClient.updateVoiceTemplate(crossinline block: UpdateVoiceTemplateRequest.Builder.() -> Unit): UpdateVoiceTemplateResponse = updateVoiceTemplate(UpdateVoiceTemplateRequest.Builder().apply(block).build())

/**
 * Verify an OTP
 */
public suspend inline fun PinpointClient.verifyOtpMessage(crossinline block: VerifyOtpMessageRequest.Builder.() -> Unit): VerifyOtpMessageResponse = verifyOtpMessage(VerifyOtpMessageRequest.Builder().apply(block).build())
