// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.serde

import aws.sdk.kotlin.services.pinpoint.model.EndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateEndpointOperationSerializer: HttpSerialize<UpdateEndpointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.endpointId) { "endpointId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("apps"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("endpoints"))
                add(PercentEncoding.SmithyLabel.encode("${input.endpointId}"))
            }
        }

        if (input.endpointRequest != null) {
            val payload = serializeEndpointRequestPayload(input.endpointRequest)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.endpointRequest == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
