// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.serde

import aws.sdk.kotlin.services.pinpoint.model.EmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailTemplateRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateEmailTemplateOperationSerializer: HttpSerialize<UpdateEmailTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateEmailTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.templateName) { "templateName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("templates"))
                add(PercentEncoding.SmithyLabel.encode("${input.templateName}"))
                add(PercentEncoding.Path.encode("email"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.createNewVersion != null) add("create-new-version", "${input.createNewVersion}")
                if (input.version != null) add("version", input.version)
            }
        }

        if (input.emailTemplateRequest != null) {
            val payload = serializeEmailTemplateRequestPayload(input.emailTemplateRequest)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.emailTemplateRequest == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
