// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.serde

import aws.sdk.kotlin.services.pinpoint.model.TagResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.TagsModel
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class TagResourceOperationSerializer: HttpSerialize<TagResourceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TagResourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.resourceArn) { "resourceArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("tags"))
                add(PercentEncoding.SmithyLabel.encode("${input.resourceArn}"))
            }
        }

        if (input.tagsModel != null) {
            val payload = serializeTagsModelPayload(input.tagsModel)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.tagsModel == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
