// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.serde

import aws.sdk.kotlin.services.pinpoint.model.GetJourneyDateRangeKpiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetJourneyDateRangeKpiOperationSerializer: HttpSerialize<GetJourneyDateRangeKpiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetJourneyDateRangeKpiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.journeyId) { "journeyId is bound to the URI and must not be null" }
            requireNotNull(input.kpiName) { "kpiName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("apps"))
                add(PercentEncoding.SmithyLabel.encode("${input.applicationId}"))
                add(PercentEncoding.Path.encode("journeys"))
                add(PercentEncoding.SmithyLabel.encode("${input.journeyId}"))
                add(PercentEncoding.Path.encode("kpis"))
                add(PercentEncoding.Path.encode("daterange"))
                add(PercentEncoding.SmithyLabel.encode("${input.kpiName}"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.endTime != null) add("end-time", input.endTime.format(TimestampFormat.ISO_8601))
                if (input.nextToken != null) add("next-token", input.nextToken)
                if (input.pageSize != null) add("page-size", input.pageSize)
                if (input.startTime != null) add("start-time", input.startTime.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
