// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the configuration and other settings for a campaign.
 */
public class WriteCampaignRequest private constructor(builder: Builder) {
    /**
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
     */
    public val additionalTreatments: List<WriteTreatmentResource>? = builder.additionalTreatments
    /**
     * The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
     */
    public val customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = builder.customDeliveryConfiguration
    /**
     * A custom description of the campaign.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    public val holdoutPercent: kotlin.Int? = builder.holdoutPercent
    /**
     * The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.
     */
    public val hook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = builder.hook
    /**
     * Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.
     */
    public val isPaused: kotlin.Boolean? = builder.isPaused
    /**
     * The messaging limits for the campaign.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = builder.limits
    /**
     * The message configuration settings for the campaign.
     */
    public val messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = builder.messageConfiguration
    /**
     * A custom name for the campaign.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The schedule settings for the campaign.
     */
    public val schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = builder.schedule
    /**
     * The unique identifier for the segment to associate with the campaign.
     */
    public val segmentId: kotlin.String? = builder.segmentId
    /**
     * The version of the segment to associate with the campaign.
     */
    public val segmentVersion: kotlin.Int? = builder.segmentVersion
    /**
     * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
     *
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The message template to use for the campaign.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * A custom description of the default treatment for the campaign.
     */
    public val treatmentDescription: kotlin.String? = builder.treatmentDescription
    /**
     * A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A *treatment* is a variation of a campaign that's used for A/B testing.
     */
    public val treatmentName: kotlin.String? = builder.treatmentName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.WriteCampaignRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WriteCampaignRequest(")
        append("additionalTreatments=$additionalTreatments,")
        append("customDeliveryConfiguration=$customDeliveryConfiguration,")
        append("description=$description,")
        append("holdoutPercent=$holdoutPercent,")
        append("hook=$hook,")
        append("isPaused=$isPaused,")
        append("limits=$limits,")
        append("messageConfiguration=$messageConfiguration,")
        append("name=$name,")
        append("priority=$priority,")
        append("schedule=$schedule,")
        append("segmentId=$segmentId,")
        append("segmentVersion=$segmentVersion,")
        append("tags=$tags,")
        append("templateConfiguration=$templateConfiguration,")
        append("treatmentDescription=$treatmentDescription,")
        append("treatmentName=$treatmentName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalTreatments?.hashCode() ?: 0
        result = 31 * result + (customDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (holdoutPercent ?: 0)
        result = 31 * result + (hook?.hashCode() ?: 0)
        result = 31 * result + (isPaused?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (messageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (segmentId?.hashCode() ?: 0)
        result = 31 * result + (segmentVersion ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (treatmentDescription?.hashCode() ?: 0)
        result = 31 * result + (treatmentName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WriteCampaignRequest

        if (additionalTreatments != other.additionalTreatments) return false
        if (customDeliveryConfiguration != other.customDeliveryConfiguration) return false
        if (description != other.description) return false
        if (holdoutPercent != other.holdoutPercent) return false
        if (hook != other.hook) return false
        if (isPaused != other.isPaused) return false
        if (limits != other.limits) return false
        if (messageConfiguration != other.messageConfiguration) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (schedule != other.schedule) return false
        if (segmentId != other.segmentId) return false
        if (segmentVersion != other.segmentVersion) return false
        if (tags != other.tags) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (treatmentDescription != other.treatmentDescription) return false
        if (treatmentName != other.treatmentName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.WriteCampaignRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
         */
        public var additionalTreatments: List<WriteTreatmentResource>? = null
        /**
         * The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
         */
        public var customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = null
        /**
         * A custom description of the campaign.
         */
        public var description: kotlin.String? = null
        /**
         * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         */
        public var holdoutPercent: kotlin.Int? = null
        /**
         * The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.
         */
        public var hook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = null
        /**
         * Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this value to false.
         */
        public var isPaused: kotlin.Boolean? = null
        /**
         * The messaging limits for the campaign.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = null
        /**
         * The message configuration settings for the campaign.
         */
        public var messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = null
        /**
         * A custom name for the campaign.
         */
        public var name: kotlin.String? = null
        /**
         * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.
         */
        public var priority: kotlin.Int? = null
        /**
         * The schedule settings for the campaign.
         */
        public var schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = null
        /**
         * The unique identifier for the segment to associate with the campaign.
         */
        public var segmentId: kotlin.String? = null
        /**
         * The version of the segment to associate with the campaign.
         */
        public var segmentVersion: kotlin.Int? = null
        /**
         * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
         *
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * The message template to use for the campaign.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = null
        /**
         * A custom description of the default treatment for the campaign.
         */
        public var treatmentDescription: kotlin.String? = null
        /**
         * A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A *treatment* is a variation of a campaign that's used for A/B testing.
         */
        public var treatmentName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.WriteCampaignRequest) : this() {
            this.additionalTreatments = x.additionalTreatments
            this.customDeliveryConfiguration = x.customDeliveryConfiguration
            this.description = x.description
            this.holdoutPercent = x.holdoutPercent
            this.hook = x.hook
            this.isPaused = x.isPaused
            this.limits = x.limits
            this.messageConfiguration = x.messageConfiguration
            this.name = x.name
            this.priority = x.priority
            this.schedule = x.schedule
            this.segmentId = x.segmentId
            this.segmentVersion = x.segmentVersion
            this.tags = x.tags
            this.templateConfiguration = x.templateConfiguration
            this.treatmentDescription = x.treatmentDescription
            this.treatmentName = x.treatmentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.WriteCampaignRequest = WriteCampaignRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration] inside the given [block]
         */
        public fun customDeliveryConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.customDeliveryConfiguration = aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignHook] inside the given [block]
         */
        public fun hook(block: aws.sdk.kotlin.services.pinpoint.model.CampaignHook.Builder.() -> kotlin.Unit) {
            this.hook = aws.sdk.kotlin.services.pinpoint.model.CampaignHook.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration] inside the given [block]
         */
        public fun messageConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.Builder.() -> kotlin.Unit) {
            this.messageConfiguration = aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.pinpoint.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.pinpoint.model.Schedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
