// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a one-time voice message that's sent directly to an endpoint through the voice channel.
 */
public class VoiceMessage private constructor(builder: Builder) {
    /**
     * The text of the script to use for the voice message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The code for the language to use when synthesizing the text of the message script. For a list of supported languages and the code for each one, see the [Amazon Polly Developer Guide](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
     */
    public val languageCode: kotlin.String? = builder.languageCode
    /**
     * The long code to send the voice message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code in E.164 format, for example +12065550100, to ensure prompt and accurate delivery of the message.
     */
    public val originationNumber: kotlin.String? = builder.originationNumber
    /**
     * The default message variables to use in the voice message. You can override the default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The name of the voice to use when delivering the message. For a list of supported voices, see the [Amazon Polly Developer Guide](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
     */
    public val voiceId: kotlin.String? = builder.voiceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.VoiceMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceMessage(")
        append("body=$body,")
        append("languageCode=$languageCode,")
        append("originationNumber=$originationNumber,")
        append("substitutions=$substitutions,")
        append("voiceId=$voiceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (originationNumber?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (voiceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VoiceMessage

        if (body != other.body) return false
        if (languageCode != other.languageCode) return false
        if (originationNumber != other.originationNumber) return false
        if (substitutions != other.substitutions) return false
        if (voiceId != other.voiceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.VoiceMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The text of the script to use for the voice message.
         */
        public var body: kotlin.String? = null
        /**
         * The code for the language to use when synthesizing the text of the message script. For a list of supported languages and the code for each one, see the [Amazon Polly Developer Guide](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
         */
        public var languageCode: kotlin.String? = null
        /**
         * The long code to send the voice message from. This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code in E.164 format, for example +12065550100, to ensure prompt and accurate delivery of the message.
         */
        public var originationNumber: kotlin.String? = null
        /**
         * The default message variables to use in the voice message. You can override the default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The name of the voice to use when delivering the message. For a list of supported voices, see the [Amazon Polly Developer Guide](https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
         */
        public var voiceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.VoiceMessage) : this() {
            this.body = x.body
            this.languageCode = x.languageCode
            this.originationNumber = x.originationNumber
            this.substitutions = x.substitutions
            this.voiceId = x.voiceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.VoiceMessage = VoiceMessage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
