// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the content and settings for a message template that can be used in text messages that are sent through the SMS channel.
 */
public class SmsTemplateResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The message body that's used in text messages that are based on the message template.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The date, in ISO 8601 format, when the message template was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The date, in ISO 8601 format, when the message template was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The unique identifier for the recommender model that's used by the message template.
     */
    public val recommenderId: kotlin.String? = builder.recommenderId
    /**
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The custom description of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription
    /**
     * The name of the message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type of channel that the message template is designed for. For an SMS template, this value is SMS.
     */
    public val templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = builder.templateType
    /**
     * The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsTemplateResponse(")
        append("arn=$arn,")
        append("body=$body,")
        append("creationDate=$creationDate,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("recommenderId=$recommenderId,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription,")
        append("templateName=$templateName,")
        append("templateType=$templateType,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (recommenderId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateType?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsTemplateResponse

        if (arn != other.arn) return false
        if (body != other.body) return false
        if (creationDate != other.creationDate) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (recommenderId != other.recommenderId) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false
        if (templateName != other.templateName) return false
        if (templateType != other.templateType) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the message template.
         */
        public var arn: kotlin.String? = null
        /**
         * The message body that's used in text messages that are based on the message template.
         */
        public var body: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the message template was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the message template was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The unique identifier for the recommender model that's used by the message template.
         */
        public var recommenderId: kotlin.String? = null
        /**
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * The custom description of the message template.
         */
        public var templateDescription: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type of channel that the message template is designed for. For an SMS template, this value is SMS.
         */
        public var templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = null
        /**
         * The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SmsTemplateResponse) : this() {
            this.arn = x.arn
            this.body = x.body
            this.creationDate = x.creationDate
            this.defaultSubstitutions = x.defaultSubstitutions
            this.lastModifiedDate = x.lastModifiedDate
            this.recommenderId = x.recommenderId
            this.tags = x.tags
            this.templateDescription = x.templateDescription
            this.templateName = x.templateName
            this.templateType = x.templateType
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateResponse = SmsTemplateResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
