// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.
 */
public class SendUsersMessageRequest private constructor(builder: Builder) {
    /**
     * A map of custom attribute-value pairs. For a push notification, Amazon Pinpoint adds these attributes to the data.pinpoint object in the body of the notification payload. Amazon Pinpoint also provides these attributes in the events that it generates for users-messages deliveries.
     */
    public val context: Map<String, String>? = builder.context
    /**
     * The settings and content for the default message and any default messages that you defined for specific channels.
     */
    public val messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration? = builder.messageConfiguration
    /**
     * The message template to use for the message.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * The unique identifier for tracing the message. This identifier is visible to message recipients.
     */
    public val traceId: kotlin.String? = builder.traceId
    /**
     * A map that associates user IDs with [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) objects. You can use an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object to tailor the message for a user by specifying settings such as content overrides and message variables.
     */
    public val users: Map<String, EndpointSendConfiguration>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendUsersMessageRequest(")
        append("context=$context,")
        append("messageConfiguration=$messageConfiguration,")
        append("templateConfiguration=$templateConfiguration,")
        append("traceId=$traceId,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = context?.hashCode() ?: 0
        result = 31 * result + (messageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (traceId?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendUsersMessageRequest

        if (context != other.context) return false
        if (messageConfiguration != other.messageConfiguration) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (traceId != other.traceId) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of custom attribute-value pairs. For a push notification, Amazon Pinpoint adds these attributes to the data.pinpoint object in the body of the notification payload. Amazon Pinpoint also provides these attributes in the events that it generates for users-messages deliveries.
         */
        public var context: Map<String, String>? = null
        /**
         * The settings and content for the default message and any default messages that you defined for specific channels.
         */
        public var messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration? = null
        /**
         * The message template to use for the message.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = null
        /**
         * The unique identifier for tracing the message. This identifier is visible to message recipients.
         */
        public var traceId: kotlin.String? = null
        /**
         * A map that associates user IDs with [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) objects. You can use an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object to tailor the message for a user by specifying settings such as content overrides and message variables.
         */
        public var users: Map<String, EndpointSendConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageRequest) : this() {
            this.context = x.context
            this.messageConfiguration = x.messageConfiguration
            this.templateConfiguration = x.templateConfiguration
            this.traceId = x.traceId
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageRequest = SendUsersMessageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration] inside the given [block]
         */
        public fun messageConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration.Builder.() -> kotlin.Unit) {
            this.messageConfiguration = aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
