// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the import job that created a segment. An import job is a job that creates a user segment by importing endpoint definitions.
 */
public class SegmentImportResource private constructor(builder: Builder) {
    /**
     * The number of channel types in the endpoint definitions that were imported to create the segment.
     */
    public val channelCounts: Map<String, Int>? = builder.channelCounts
    /**
     * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.
     */
    public val format: aws.sdk.kotlin.services.pinpoint.model.Format? = builder.format
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.
     */
    public val s3Url: kotlin.String? = builder.s3Url
    /**
     * The number of endpoint definitions that were imported successfully to create the segment.
     */
    public val size: kotlin.Int? = builder.size

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SegmentImportResource(")
        append("channelCounts=$channelCounts,")
        append("externalId=$externalId,")
        append("format=$format,")
        append("roleArn=$roleArn,")
        append("s3Url=$s3Url,")
        append("size=$size")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelCounts?.hashCode() ?: 0
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Url?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SegmentImportResource

        if (channelCounts != other.channelCounts) return false
        if (externalId != other.externalId) return false
        if (format != other.format) return false
        if (roleArn != other.roleArn) return false
        if (s3Url != other.s3Url) return false
        if (size != other.size) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of channel types in the endpoint definitions that were imported to create the segment.
         */
        public var channelCounts: Map<String, Int>? = null
        /**
         * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
         */
        public var externalId: kotlin.String? = null
        /**
         * The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.
         */
        public var format: aws.sdk.kotlin.services.pinpoint.model.Format? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.
         */
        public var s3Url: kotlin.String? = null
        /**
         * The number of endpoint definitions that were imported successfully to create the segment.
         */
        public var size: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource) : this() {
            this.channelCounts = x.channelCounts
            this.externalId = x.externalId
            this.format = x.format
            this.roleArn = x.roleArn
            this.s3Url = x.s3Url
            this.size = x.size
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SegmentImportResource = SegmentImportResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
