// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.
 */
public class RecommenderConfigurationResponse private constructor(builder: Builder) {
    /**
     * A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.
     *
     * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The custom description of the configuration for the recommender model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the recommender model configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The custom name of the configuration for the recommender model.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:
     * + PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     * + PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.
     */
    public val recommendationProviderIdType: kotlin.String? = builder.recommendationProviderIdType
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.
     */
    public val recommendationProviderRoleArn: kotlin.String? = builder.recommendationProviderRoleArn
    /**
     * The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.
     */
    public val recommendationProviderUri: kotlin.String? = builder.recommendationProviderUri
    /**
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.
     */
    public val recommendationTransformerUri: kotlin.String? = builder.recommendationTransformerUri
    /**
     * The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console.
     *
     * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public val recommendationsDisplayName: kotlin.String? = builder.recommendationsDisplayName
    /**
     * The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.
     */
    public val recommendationsPerMessage: kotlin.Int? = builder.recommendationsPerMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.RecommenderConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommenderConfigurationResponse(")
        append("attributes=$attributes,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("name=$name,")
        append("recommendationProviderIdType=$recommendationProviderIdType,")
        append("recommendationProviderRoleArn=$recommendationProviderRoleArn,")
        append("recommendationProviderUri=$recommendationProviderUri,")
        append("recommendationTransformerUri=$recommendationTransformerUri,")
        append("recommendationsDisplayName=$recommendationsDisplayName,")
        append("recommendationsPerMessage=$recommendationsPerMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderIdType?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderRoleArn?.hashCode() ?: 0)
        result = 31 * result + (recommendationProviderUri?.hashCode() ?: 0)
        result = 31 * result + (recommendationTransformerUri?.hashCode() ?: 0)
        result = 31 * result + (recommendationsDisplayName?.hashCode() ?: 0)
        result = 31 * result + (recommendationsPerMessage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommenderConfigurationResponse

        if (attributes != other.attributes) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (name != other.name) return false
        if (recommendationProviderIdType != other.recommendationProviderIdType) return false
        if (recommendationProviderRoleArn != other.recommendationProviderRoleArn) return false
        if (recommendationProviderUri != other.recommendationProviderUri) return false
        if (recommendationTransformerUri != other.recommendationTransformerUri) return false
        if (recommendationsDisplayName != other.recommendationsDisplayName) return false
        if (recommendationsPerMessage != other.recommendationsPerMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.RecommenderConfigurationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.
         *
         * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The custom description of the configuration for the recommender model.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the recommender model configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The custom name of the configuration for the recommender model.
         */
        public var name: kotlin.String? = null
        /**
         * The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:
         * + PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         * + PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user's endpoint.
         */
        public var recommendationProviderIdType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.
         */
        public var recommendationProviderRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.
         */
        public var recommendationProviderUri: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.
         */
        public var recommendationTransformerUri: kotlin.String? = null
        /**
         * The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the **Attribute finder** of the template editor on the Amazon Pinpoint console.
         *
         * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         */
        public var recommendationsDisplayName: kotlin.String? = null
        /**
         * The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.
         */
        public var recommendationsPerMessage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.RecommenderConfigurationResponse) : this() {
            this.attributes = x.attributes
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.lastModifiedDate = x.lastModifiedDate
            this.name = x.name
            this.recommendationProviderIdType = x.recommendationProviderIdType
            this.recommendationProviderRoleArn = x.recommendationProviderRoleArn
            this.recommendationProviderUri = x.recommendationProviderUri
            this.recommendationTransformerUri = x.recommendationTransformerUri
            this.recommendationsDisplayName = x.recommendationsDisplayName
            this.recommendationsPerMessage = x.recommendationsPerMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.RecommenderConfigurationResponse = RecommenderConfigurationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
