// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a path in a random split activity in a journey.
 */
public class RandomSplitEntry private constructor(builder: Builder) {
    /**
     * The unique identifier for the next activity to perform, after completing the activity for the path.
     */
    public val nextActivity: kotlin.String? = builder.nextActivity
    /**
     * The percentage of participants to send down the activity path.
     *
     * To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.
     */
    public val percentage: kotlin.Int? = builder.percentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.RandomSplitEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RandomSplitEntry(")
        append("nextActivity=$nextActivity,")
        append("percentage=$percentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextActivity?.hashCode() ?: 0
        result = 31 * result + (percentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RandomSplitEntry

        if (nextActivity != other.nextActivity) return false
        if (percentage != other.percentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.RandomSplitEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the next activity to perform, after completing the activity for the path.
         */
        public var nextActivity: kotlin.String? = null
        /**
         * The percentage of participants to send down the activity path.
         *
         * To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.
         */
        public var percentage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.RandomSplitEntry) : this() {
            this.nextActivity = x.nextActivity
            this.percentage = x.percentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.RandomSplitEntry = RandomSplitEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
