// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the properties and attributes of an endpoint that's associated with an event.
 */
public class PublicEndpoint private constructor(builder: Builder) {
    /**
     * The unique identifier for the recipient, such as a device token, email address, or mobile phone number.
     */
    public val address: kotlin.String? = builder.address
    /**
     * One or more custom attributes that describe the endpoint by associating a name with an array of values. You can use these attributes as filter criteria when you create segments.
     */
    public val attributes: Map<String, List<String>>? = builder.attributes
    /**
     * The channel that's used when sending messages or push notifications to the endpoint.
     */
    public val channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = builder.channelType
    /**
     * The demographic information for the endpoint, such as the time zone and platform.
     */
    public val demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = builder.demographic
    /**
     * The date and time, in ISO 8601 format, when the endpoint was last updated.
     */
    public val effectiveDate: kotlin.String? = builder.effectiveDate
    /**
     * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
     *
     * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
     */
    public val endpointStatus: kotlin.String? = builder.endpointStatus
    /**
     * The geographic information for the endpoint.
     */
    public val location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = builder.location
    /**
     * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     */
    public val metrics: Map<String, Double>? = builder.metrics
    /**
     * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
     */
    public val optOut: kotlin.String? = builder.optOut
    /**
     * A unique identifier that's generated each time the endpoint is updated.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with the endpoint.
     */
    public val user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.PublicEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublicEndpoint(")
        append("address=$address,")
        append("attributes=$attributes,")
        append("channelType=$channelType,")
        append("demographic=$demographic,")
        append("effectiveDate=$effectiveDate,")
        append("endpointStatus=$endpointStatus,")
        append("location=$location,")
        append("metrics=$metrics,")
        append("optOut=$optOut,")
        append("requestId=$requestId,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (channelType?.hashCode() ?: 0)
        result = 31 * result + (demographic?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (optOut?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublicEndpoint

        if (address != other.address) return false
        if (attributes != other.attributes) return false
        if (channelType != other.channelType) return false
        if (demographic != other.demographic) return false
        if (effectiveDate != other.effectiveDate) return false
        if (endpointStatus != other.endpointStatus) return false
        if (location != other.location) return false
        if (metrics != other.metrics) return false
        if (optOut != other.optOut) return false
        if (requestId != other.requestId) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.PublicEndpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the recipient, such as a device token, email address, or mobile phone number.
         */
        public var address: kotlin.String? = null
        /**
         * One or more custom attributes that describe the endpoint by associating a name with an array of values. You can use these attributes as filter criteria when you create segments.
         */
        public var attributes: Map<String, List<String>>? = null
        /**
         * The channel that's used when sending messages or push notifications to the endpoint.
         */
        public var channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = null
        /**
         * The demographic information for the endpoint, such as the time zone and platform.
         */
        public var demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = null
        /**
         * The date and time, in ISO 8601 format, when the endpoint was last updated.
         */
        public var effectiveDate: kotlin.String? = null
        /**
         * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
         *
         * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
         */
        public var endpointStatus: kotlin.String? = null
        /**
         * The geographic information for the endpoint.
         */
        public var location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = null
        /**
         * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         */
        public var metrics: Map<String, Double>? = null
        /**
         * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
         */
        public var optOut: kotlin.String? = null
        /**
         * A unique identifier that's generated each time the endpoint is updated.
         */
        public var requestId: kotlin.String? = null
        /**
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with the endpoint.
         */
        public var user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.PublicEndpoint) : this() {
            this.address = x.address
            this.attributes = x.attributes
            this.channelType = x.channelType
            this.demographic = x.demographic
            this.effectiveDate = x.effectiveDate
            this.endpointStatus = x.endpointStatus
            this.location = x.location
            this.metrics = x.metrics
            this.optOut = x.optOut
            this.requestId = x.requestId
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.PublicEndpoint = PublicEndpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic] inside the given [block]
         */
        public fun demographic(block: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.Builder.() -> kotlin.Unit) {
            this.demographic = aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointUser] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.pinpoint.model.EndpointUser.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.pinpoint.model.EndpointUser.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
