// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the message configuration settings for a campaign.
 */
public class MessageConfiguration private constructor(builder: Builder) {
    /**
     * The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.
     */
    public val admMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = builder.admMessage
    /**
     * The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.
     */
    public val apnsMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = builder.apnsMessage
    /**
     * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.
     */
    public val baiduMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = builder.baiduMessage
    /**
     * The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.
     */
    public val customMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignCustomMessage? = builder.customMessage
    /**
     * The default message that the campaign sends through all the channels that are configured for the campaign.
     */
    public val defaultMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = builder.defaultMessage
    /**
     * The message that the campaign sends through the email channel. If specified, this message overrides the default message.
     */
    public val emailMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage? = builder.emailMessage
    /**
     * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.
     */
    public val gcmMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = builder.gcmMessage
    /**
     * The in-app message configuration.
     */
    public val inAppMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignInAppMessage? = builder.inAppMessage
    /**
     * The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.
     */
    public val smsMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignSmsMessage? = builder.smsMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageConfiguration(")
        append("admMessage=$admMessage,")
        append("apnsMessage=$apnsMessage,")
        append("baiduMessage=$baiduMessage,")
        append("customMessage=$customMessage,")
        append("defaultMessage=$defaultMessage,")
        append("emailMessage=$emailMessage,")
        append("gcmMessage=$gcmMessage,")
        append("inAppMessage=$inAppMessage,")
        append("smsMessage=$smsMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = admMessage?.hashCode() ?: 0
        result = 31 * result + (apnsMessage?.hashCode() ?: 0)
        result = 31 * result + (baiduMessage?.hashCode() ?: 0)
        result = 31 * result + (customMessage?.hashCode() ?: 0)
        result = 31 * result + (defaultMessage?.hashCode() ?: 0)
        result = 31 * result + (emailMessage?.hashCode() ?: 0)
        result = 31 * result + (gcmMessage?.hashCode() ?: 0)
        result = 31 * result + (inAppMessage?.hashCode() ?: 0)
        result = 31 * result + (smsMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageConfiguration

        if (admMessage != other.admMessage) return false
        if (apnsMessage != other.apnsMessage) return false
        if (baiduMessage != other.baiduMessage) return false
        if (customMessage != other.customMessage) return false
        if (defaultMessage != other.defaultMessage) return false
        if (emailMessage != other.emailMessage) return false
        if (gcmMessage != other.gcmMessage) return false
        if (inAppMessage != other.inAppMessage) return false
        if (smsMessage != other.smsMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.
         */
        public var admMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = null
        /**
         * The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.
         */
        public var apnsMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = null
        /**
         * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.
         */
        public var baiduMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = null
        /**
         * The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.
         */
        public var customMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignCustomMessage? = null
        /**
         * The default message that the campaign sends through all the channels that are configured for the campaign.
         */
        public var defaultMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = null
        /**
         * The message that the campaign sends through the email channel. If specified, this message overrides the default message.
         */
        public var emailMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage? = null
        /**
         * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.
         */
        public var gcmMessage: aws.sdk.kotlin.services.pinpoint.model.Message? = null
        /**
         * The in-app message configuration.
         */
        public var inAppMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignInAppMessage? = null
        /**
         * The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.
         */
        public var smsMessage: aws.sdk.kotlin.services.pinpoint.model.CampaignSmsMessage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration) : this() {
            this.admMessage = x.admMessage
            this.apnsMessage = x.apnsMessage
            this.baiduMessage = x.baiduMessage
            this.customMessage = x.customMessage
            this.defaultMessage = x.defaultMessage
            this.emailMessage = x.emailMessage
            this.gcmMessage = x.gcmMessage
            this.inAppMessage = x.inAppMessage
            this.smsMessage = x.smsMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration = MessageConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Message] inside the given [block]
         */
        public fun admMessage(block: aws.sdk.kotlin.services.pinpoint.model.Message.Builder.() -> kotlin.Unit) {
            this.admMessage = aws.sdk.kotlin.services.pinpoint.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Message] inside the given [block]
         */
        public fun apnsMessage(block: aws.sdk.kotlin.services.pinpoint.model.Message.Builder.() -> kotlin.Unit) {
            this.apnsMessage = aws.sdk.kotlin.services.pinpoint.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Message] inside the given [block]
         */
        public fun baiduMessage(block: aws.sdk.kotlin.services.pinpoint.model.Message.Builder.() -> kotlin.Unit) {
            this.baiduMessage = aws.sdk.kotlin.services.pinpoint.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignCustomMessage] inside the given [block]
         */
        public fun customMessage(block: aws.sdk.kotlin.services.pinpoint.model.CampaignCustomMessage.Builder.() -> kotlin.Unit) {
            this.customMessage = aws.sdk.kotlin.services.pinpoint.model.CampaignCustomMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Message] inside the given [block]
         */
        public fun defaultMessage(block: aws.sdk.kotlin.services.pinpoint.model.Message.Builder.() -> kotlin.Unit) {
            this.defaultMessage = aws.sdk.kotlin.services.pinpoint.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage] inside the given [block]
         */
        public fun emailMessage(block: aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage.Builder.() -> kotlin.Unit) {
            this.emailMessage = aws.sdk.kotlin.services.pinpoint.model.CampaignEmailMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Message] inside the given [block]
         */
        public fun gcmMessage(block: aws.sdk.kotlin.services.pinpoint.model.Message.Builder.() -> kotlin.Unit) {
            this.gcmMessage = aws.sdk.kotlin.services.pinpoint.model.Message.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignInAppMessage] inside the given [block]
         */
        public fun inAppMessage(block: aws.sdk.kotlin.services.pinpoint.model.CampaignInAppMessage.Builder.() -> kotlin.Unit) {
            this.inAppMessage = aws.sdk.kotlin.services.pinpoint.model.CampaignInAppMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignSmsMessage] inside the given [block]
         */
        public fun smsMessage(block: aws.sdk.kotlin.services.pinpoint.model.CampaignSmsMessage.Builder.() -> kotlin.Unit) {
            this.smsMessage = aws.sdk.kotlin.services.pinpoint.model.CampaignSmsMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
