// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the status, configuration, and other settings for a journey.
 */
public class JourneyResponse private constructor(builder: Builder) {
    /**
     * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.
     */
    public val activities: Map<String, Activity>? = builder.activities
    /**
     * The unique identifier for the application that the journey applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The time when a journey will not send messages. QuietTime should be configured first and SendingSchedule should be set to true.
     */
    public val closedDays: aws.sdk.kotlin.services.pinpoint.model.ClosedDays? = builder.closedDays
    /**
     * The date, in ISO 8601 format, when the journey was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The unique identifier for the journey.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The channel-specific configurations for the journey.
     */
    public val journeyChannelSettings: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings? = builder.journeyChannelSettings
    /**
     * The date, in ISO 8601 format, when the journey was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The messaging and entry limits for the journey.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits? = builder.limits
    /**
     * Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.
     */
    public val localTime: kotlin.Boolean? = builder.localTime
    /**
     * The name of the journey.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The time when a journey can send messages. QuietTime should be configured first and SendingSchedule should be set to true.
     */
    public val openHours: aws.sdk.kotlin.services.pinpoint.model.OpenHours? = builder.openHours
    /**
     * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:
     * + The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
     * + The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.
     * + The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.
     *
     * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.
     */
    public val quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = builder.quietTime
    /**
     * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.
     */
    public val refreshFrequency: kotlin.String? = builder.refreshFrequency
    /**
     * Indicates whether the journey participants should be refreshed when a segment is updated.
     */
    public val refreshOnSegmentUpdate: kotlin.Boolean? = builder.refreshOnSegmentUpdate
    /**
     * The schedule settings for the journey.
     */
    public val schedule: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule? = builder.schedule
    /**
     * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.
     */
    public val sendingSchedule: kotlin.Boolean? = builder.sendingSchedule
    /**
     * The unique identifier for the first activity in the journey.
     */
    public val startActivity: kotlin.String? = builder.startActivity
    /**
     * The segment that defines which users are participants in the journey.
     */
    public val startCondition: aws.sdk.kotlin.services.pinpoint.model.StartCondition? = builder.startCondition
    /**
     * The current status of the journey. Possible values are:
     * + DRAFT - The journey is being developed and hasn't been published yet.
     * + ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.
     * + COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.
     * + CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.
     * + CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.
     */
    public val state: aws.sdk.kotlin.services.pinpoint.model.State? = builder.state
    /**
     * This object is not used or supported.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * An array of time zone estimation methods, if any, to use for determining an [Endpoints](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html) time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
     * + PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     * + POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     */
    public val timezoneEstimationMethods: List<TimezoneEstimationMethodsElement>? = builder.timezoneEstimationMethods
    /**
     * Indicates whether endpoints in quiet hours should enter a wait activity until quiet hours have elapsed.
     */
    public val waitForQuietTime: kotlin.Boolean? = builder.waitForQuietTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.JourneyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JourneyResponse(")
        append("activities=$activities,")
        append("applicationId=$applicationId,")
        append("closedDays=$closedDays,")
        append("creationDate=$creationDate,")
        append("id=$id,")
        append("journeyChannelSettings=$journeyChannelSettings,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("limits=$limits,")
        append("localTime=$localTime,")
        append("name=$name,")
        append("openHours=$openHours,")
        append("quietTime=$quietTime,")
        append("refreshFrequency=$refreshFrequency,")
        append("refreshOnSegmentUpdate=$refreshOnSegmentUpdate,")
        append("schedule=$schedule,")
        append("sendingSchedule=$sendingSchedule,")
        append("startActivity=$startActivity,")
        append("startCondition=$startCondition,")
        append("state=$state,")
        append("tags=$tags,")
        append("timezoneEstimationMethods=$timezoneEstimationMethods,")
        append("waitForQuietTime=$waitForQuietTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activities?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (closedDays?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (journeyChannelSettings?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (localTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openHours?.hashCode() ?: 0)
        result = 31 * result + (quietTime?.hashCode() ?: 0)
        result = 31 * result + (refreshFrequency?.hashCode() ?: 0)
        result = 31 * result + (refreshOnSegmentUpdate?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sendingSchedule?.hashCode() ?: 0)
        result = 31 * result + (startActivity?.hashCode() ?: 0)
        result = 31 * result + (startCondition?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timezoneEstimationMethods?.hashCode() ?: 0)
        result = 31 * result + (waitForQuietTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JourneyResponse

        if (activities != other.activities) return false
        if (applicationId != other.applicationId) return false
        if (closedDays != other.closedDays) return false
        if (creationDate != other.creationDate) return false
        if (id != other.id) return false
        if (journeyChannelSettings != other.journeyChannelSettings) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (limits != other.limits) return false
        if (localTime != other.localTime) return false
        if (name != other.name) return false
        if (openHours != other.openHours) return false
        if (quietTime != other.quietTime) return false
        if (refreshFrequency != other.refreshFrequency) return false
        if (refreshOnSegmentUpdate != other.refreshOnSegmentUpdate) return false
        if (schedule != other.schedule) return false
        if (sendingSchedule != other.sendingSchedule) return false
        if (startActivity != other.startActivity) return false
        if (startCondition != other.startCondition) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (timezoneEstimationMethods != other.timezoneEstimationMethods) return false
        if (waitForQuietTime != other.waitForQuietTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.JourneyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.
         */
        public var activities: Map<String, Activity>? = null
        /**
         * The unique identifier for the application that the journey applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The time when a journey will not send messages. QuietTime should be configured first and SendingSchedule should be set to true.
         */
        public var closedDays: aws.sdk.kotlin.services.pinpoint.model.ClosedDays? = null
        /**
         * The date, in ISO 8601 format, when the journey was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The unique identifier for the journey.
         */
        public var id: kotlin.String? = null
        /**
         * The channel-specific configurations for the journey.
         */
        public var journeyChannelSettings: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings? = null
        /**
         * The date, in ISO 8601 format, when the journey was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The messaging and entry limits for the journey.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits? = null
        /**
         * Specifies whether the journey's scheduled start and end times use each participant's local time. If this value is true, the schedule uses each participant's local time.
         */
        public var localTime: kotlin.Boolean? = null
        /**
         * The name of the journey.
         */
        public var name: kotlin.String? = null
        /**
         * The time when a journey can send messages. QuietTime should be configured first and SendingSchedule should be set to true.
         */
        public var openHours: aws.sdk.kotlin.services.pinpoint.model.OpenHours? = null
        /**
         * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages to participants, if all the following conditions are met:
         * + The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
         * + The current time in the participant's time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.
         * + The current time in the participant's time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.
         *
         * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if quiet time is enabled.
         */
        public var quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = null
        /**
         * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.
         */
        public var refreshFrequency: kotlin.String? = null
        /**
         * Indicates whether the journey participants should be refreshed when a segment is updated.
         */
        public var refreshOnSegmentUpdate: kotlin.Boolean? = null
        /**
         * The schedule settings for the journey.
         */
        public var schedule: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule? = null
        /**
         * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.
         */
        public var sendingSchedule: kotlin.Boolean? = null
        /**
         * The unique identifier for the first activity in the journey.
         */
        public var startActivity: kotlin.String? = null
        /**
         * The segment that defines which users are participants in the journey.
         */
        public var startCondition: aws.sdk.kotlin.services.pinpoint.model.StartCondition? = null
        /**
         * The current status of the journey. Possible values are:
         * + DRAFT - The journey is being developed and hasn't been published yet.
         * + ACTIVE - The journey has been developed and published. Depending on the journey's schedule, the journey may currently be running or scheduled to start running at a later time. If a journey's status is ACTIVE, you can't add, change, or remove activities from it.
         * + COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.
         * + CANCELLED - The journey has been stopped. If a journey's status is CANCELLED, you can't add, change, or remove activities or segment settings from the journey.
         * + CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn't been specified for it. If a journey's status is CLOSED, you can't add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.
         */
        public var state: aws.sdk.kotlin.services.pinpoint.model.State? = null
        /**
         * This object is not used or supported.
         */
        public var tags: Map<String, String>? = null
        /**
         * An array of time zone estimation methods, if any, to use for determining an [Endpoints](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html) time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * + PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * + POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         */
        public var timezoneEstimationMethods: List<TimezoneEstimationMethodsElement>? = null
        /**
         * Indicates whether endpoints in quiet hours should enter a wait activity until quiet hours have elapsed.
         */
        public var waitForQuietTime: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.JourneyResponse) : this() {
            this.activities = x.activities
            this.applicationId = x.applicationId
            this.closedDays = x.closedDays
            this.creationDate = x.creationDate
            this.id = x.id
            this.journeyChannelSettings = x.journeyChannelSettings
            this.lastModifiedDate = x.lastModifiedDate
            this.limits = x.limits
            this.localTime = x.localTime
            this.name = x.name
            this.openHours = x.openHours
            this.quietTime = x.quietTime
            this.refreshFrequency = x.refreshFrequency
            this.refreshOnSegmentUpdate = x.refreshOnSegmentUpdate
            this.schedule = x.schedule
            this.sendingSchedule = x.sendingSchedule
            this.startActivity = x.startActivity
            this.startCondition = x.startCondition
            this.state = x.state
            this.tags = x.tags
            this.timezoneEstimationMethods = x.timezoneEstimationMethods
            this.waitForQuietTime = x.waitForQuietTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.JourneyResponse = JourneyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ClosedDays] inside the given [block]
         */
        public fun closedDays(block: aws.sdk.kotlin.services.pinpoint.model.ClosedDays.Builder.() -> kotlin.Unit) {
            this.closedDays = aws.sdk.kotlin.services.pinpoint.model.ClosedDays.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings] inside the given [block]
         */
        public fun journeyChannelSettings(block: aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings.Builder.() -> kotlin.Unit) {
            this.journeyChannelSettings = aws.sdk.kotlin.services.pinpoint.model.JourneyChannelSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.JourneyLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.OpenHours] inside the given [block]
         */
        public fun openHours(block: aws.sdk.kotlin.services.pinpoint.model.OpenHours.Builder.() -> kotlin.Unit) {
            this.openHours = aws.sdk.kotlin.services.pinpoint.model.OpenHours.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.QuietTime] inside the given [block]
         */
        public fun quietTime(block: aws.sdk.kotlin.services.pinpoint.model.QuietTime.Builder.() -> kotlin.Unit) {
            this.quietTime = aws.sdk.kotlin.services.pinpoint.model.QuietTime.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneySchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.pinpoint.model.JourneySchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.pinpoint.model.JourneySchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.StartCondition] inside the given [block]
         */
        public fun startCondition(block: aws.sdk.kotlin.services.pinpoint.model.StartCondition.Builder.() -> kotlin.Unit) {
            this.startCondition = aws.sdk.kotlin.services.pinpoint.model.StartCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
