// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies limits on the messages that a journey can send and the number of times participants can enter a journey.
 */
public class JourneyLimits private constructor(builder: Builder) {
    /**
     * The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.
     */
    public val dailyCap: kotlin.Int? = builder.dailyCap
    /**
     * The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.
     */
    public val endpointReentryCap: kotlin.Int? = builder.endpointReentryCap
    /**
     * Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H.
     */
    public val endpointReentryInterval: kotlin.String? = builder.endpointReentryInterval
    /**
     * The maximum number of messages that the journey can send each second.
     */
    public val messagesPerSecond: kotlin.Int? = builder.messagesPerSecond
    /**
     * The number of messages that an endpoint can receive during the specified timeframe.
     */
    public val timeframeCap: aws.sdk.kotlin.services.pinpoint.model.JourneyTimeframeCap? = builder.timeframeCap
    /**
     * The maximum number of messages a journey can sent to a single endpoint. The maximum value is 100. If set to 0, this limit will not apply.
     */
    public val totalCap: kotlin.Int? = builder.totalCap

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.JourneyLimits = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JourneyLimits(")
        append("dailyCap=$dailyCap,")
        append("endpointReentryCap=$endpointReentryCap,")
        append("endpointReentryInterval=$endpointReentryInterval,")
        append("messagesPerSecond=$messagesPerSecond,")
        append("timeframeCap=$timeframeCap,")
        append("totalCap=$totalCap")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dailyCap ?: 0
        result = 31 * result + (endpointReentryCap ?: 0)
        result = 31 * result + (endpointReentryInterval?.hashCode() ?: 0)
        result = 31 * result + (messagesPerSecond ?: 0)
        result = 31 * result + (timeframeCap?.hashCode() ?: 0)
        result = 31 * result + (totalCap ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JourneyLimits

        if (dailyCap != other.dailyCap) return false
        if (endpointReentryCap != other.endpointReentryCap) return false
        if (endpointReentryInterval != other.endpointReentryInterval) return false
        if (messagesPerSecond != other.messagesPerSecond) return false
        if (timeframeCap != other.timeframeCap) return false
        if (totalCap != other.totalCap) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.JourneyLimits = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.
         */
        public var dailyCap: kotlin.Int? = null
        /**
         * The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.
         */
        public var endpointReentryCap: kotlin.Int? = null
        /**
         * Minimum time that must pass before an endpoint can re-enter a given journey. The duration should use an ISO 8601 format, such as PT1H.
         */
        public var endpointReentryInterval: kotlin.String? = null
        /**
         * The maximum number of messages that the journey can send each second.
         */
        public var messagesPerSecond: kotlin.Int? = null
        /**
         * The number of messages that an endpoint can receive during the specified timeframe.
         */
        public var timeframeCap: aws.sdk.kotlin.services.pinpoint.model.JourneyTimeframeCap? = null
        /**
         * The maximum number of messages a journey can sent to a single endpoint. The maximum value is 100. If set to 0, this limit will not apply.
         */
        public var totalCap: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.JourneyLimits) : this() {
            this.dailyCap = x.dailyCap
            this.endpointReentryCap = x.endpointReentryCap
            this.endpointReentryInterval = x.endpointReentryInterval
            this.messagesPerSecond = x.messagesPerSecond
            this.timeframeCap = x.timeframeCap
            this.totalCap = x.totalCap
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.JourneyLimits = JourneyLimits(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneyTimeframeCap] inside the given [block]
         */
        public fun timeframeCap(block: aws.sdk.kotlin.services.pinpoint.model.JourneyTimeframeCap.Builder.() -> kotlin.Unit) {
            this.timeframeCap = aws.sdk.kotlin.services.pinpoint.model.JourneyTimeframeCap.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
