// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a holdout activity in a journey. This type of activity stops a journey for a specified percentage of participants.
 */
public class HoldoutActivity private constructor(builder: Builder) {
    /**
     * The unique identifier for the next activity to perform, after performing the holdout activity.
     */
    public val nextActivity: kotlin.String? = builder.nextActivity
    /**
     * The percentage of participants who shouldn't continue the journey.
     *
     * To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.
     */
    public val percentage: kotlin.Int? = builder.percentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.HoldoutActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HoldoutActivity(")
        append("nextActivity=$nextActivity,")
        append("percentage=$percentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextActivity?.hashCode() ?: 0
        result = 31 * result + (percentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HoldoutActivity

        if (nextActivity != other.nextActivity) return false
        if (percentage != other.percentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.HoldoutActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the next activity to perform, after performing the holdout activity.
         */
        public var nextActivity: kotlin.String? = null
        /**
         * The percentage of participants who shouldn't continue the journey.
         *
         * To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.
         */
        public var percentage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.HoldoutActivity) : this() {
            this.nextActivity = x.nextActivity
            this.percentage = x.percentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.HoldoutActivity = HoldoutActivity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
