// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the dimensions for an event filter that determines when a campaign is sent or a journey activity is performed.
 */
public class EventDimensions private constructor(builder: Builder) {
    /**
     * One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.
     */
    public val attributes: Map<String, AttributeDimension>? = builder.attributes
    /**
     * The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see [Streaming Amazon Pinpoint Events](https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public val eventType: aws.sdk.kotlin.services.pinpoint.model.SetDimension? = builder.eventType
    /**
     * One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.
     */
    public val metrics: Map<String, MetricDimension>? = builder.metrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EventDimensions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDimensions(")
        append("attributes=$attributes,")
        append("eventType=$eventType,")
        append("metrics=$metrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDimensions

        if (attributes != other.attributes) return false
        if (eventType != other.eventType) return false
        if (metrics != other.metrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EventDimensions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.
         */
        public var attributes: Map<String, AttributeDimension>? = null
        /**
         * The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see [Streaming Amazon Pinpoint Events](https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html) in the *Amazon Pinpoint Developer Guide*.
         */
        public var eventType: aws.sdk.kotlin.services.pinpoint.model.SetDimension? = null
        /**
         * One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.
         */
        public var metrics: Map<String, MetricDimension>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EventDimensions) : this() {
            this.attributes = x.attributes
            this.eventType = x.eventType
            this.metrics = x.metrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EventDimensions = EventDimensions(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SetDimension] inside the given [block]
         */
        public fun eventType(block: aws.sdk.kotlin.services.pinpoint.model.SetDimension.Builder.() -> kotlin.Unit) {
            this.eventType = aws.sdk.kotlin.services.pinpoint.model.SetDimension.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
