// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies information about an event that reports data to Amazon Pinpoint.
 */
public class Event private constructor(builder: Builder) {
    /**
     * The package name of the app that's recording the event.
     */
    public val appPackageName: kotlin.String? = builder.appPackageName
    /**
     * The title of the app that's recording the event.
     */
    public val appTitle: kotlin.String? = builder.appTitle
    /**
     * The version number of the app that's recording the event.
     */
    public val appVersionCode: kotlin.String? = builder.appVersionCode
    /**
     * One or more custom attributes that are associated with the event.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The version of the SDK that's running on the client device.
     */
    public val clientSdkVersion: kotlin.String? = builder.clientSdkVersion
    /**
     * The name of the event.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * One or more custom metrics that are associated with the event.
     */
    public val metrics: Map<String, Double>? = builder.metrics
    /**
     * The name of the SDK that's being used to record the event.
     */
    public val sdkName: kotlin.String? = builder.sdkName
    /**
     * Information about the session in which the event occurred.
     */
    public val session: aws.sdk.kotlin.services.pinpoint.model.Session? = builder.session
    /**
     * The date and time, in ISO 8601 format, when the event occurred.
     */
    public val timestamp: kotlin.String? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("appPackageName=$appPackageName,")
        append("appTitle=$appTitle,")
        append("appVersionCode=$appVersionCode,")
        append("attributes=$attributes,")
        append("clientSdkVersion=$clientSdkVersion,")
        append("eventType=$eventType,")
        append("metrics=$metrics,")
        append("sdkName=$sdkName,")
        append("session=$session,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appPackageName?.hashCode() ?: 0
        result = 31 * result + (appTitle?.hashCode() ?: 0)
        result = 31 * result + (appVersionCode?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (clientSdkVersion?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (sdkName?.hashCode() ?: 0)
        result = 31 * result + (session?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (appPackageName != other.appPackageName) return false
        if (appTitle != other.appTitle) return false
        if (appVersionCode != other.appVersionCode) return false
        if (attributes != other.attributes) return false
        if (clientSdkVersion != other.clientSdkVersion) return false
        if (eventType != other.eventType) return false
        if (metrics != other.metrics) return false
        if (sdkName != other.sdkName) return false
        if (session != other.session) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.Event = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The package name of the app that's recording the event.
         */
        public var appPackageName: kotlin.String? = null
        /**
         * The title of the app that's recording the event.
         */
        public var appTitle: kotlin.String? = null
        /**
         * The version number of the app that's recording the event.
         */
        public var appVersionCode: kotlin.String? = null
        /**
         * One or more custom attributes that are associated with the event.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The version of the SDK that's running on the client device.
         */
        public var clientSdkVersion: kotlin.String? = null
        /**
         * The name of the event.
         */
        public var eventType: kotlin.String? = null
        /**
         * One or more custom metrics that are associated with the event.
         */
        public var metrics: Map<String, Double>? = null
        /**
         * The name of the SDK that's being used to record the event.
         */
        public var sdkName: kotlin.String? = null
        /**
         * Information about the session in which the event occurred.
         */
        public var session: aws.sdk.kotlin.services.pinpoint.model.Session? = null
        /**
         * The date and time, in ISO 8601 format, when the event occurred.
         */
        public var timestamp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.Event) : this() {
            this.appPackageName = x.appPackageName
            this.appTitle = x.appTitle
            this.appVersionCode = x.appVersionCode
            this.attributes = x.attributes
            this.clientSdkVersion = x.clientSdkVersion
            this.eventType = x.eventType
            this.metrics = x.metrics
            this.sdkName = x.sdkName
            this.session = x.session
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.Event = Event(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Session] inside the given [block]
         */
        public fun session(block: aws.sdk.kotlin.services.pinpoint.model.Session.Builder.() -> kotlin.Unit) {
            this.session = aws.sdk.kotlin.services.pinpoint.model.Session.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
