// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies data for one or more attributes that describe the user who's associated with an endpoint.
 */
public class EndpointUser private constructor(builder: Builder) {
    /**
     * One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.
     *
     * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.
     */
    public val userAttributes: Map<String, List<String>>? = builder.userAttributes
    /**
     * The unique identifier for the user.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EndpointUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointUser(")
        append("userAttributes=$userAttributes,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = userAttributes?.hashCode() ?: 0
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointUser

        if (userAttributes != other.userAttributes) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EndpointUser = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.
         *
         * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.
         */
        public var userAttributes: Map<String, List<String>>? = null
        /**
         * The unique identifier for the user.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EndpointUser) : this() {
            this.userAttributes = x.userAttributes
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EndpointUser = EndpointUser(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
