// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the channel type and other settings for an endpoint.
 */
public class EndpointResponse private constructor(builder: Builder) {
    /**
     * The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For example, the address for a push-notification channel is typically the token provided by a push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. The address for the SMS channel is a phone number in E.164 format, such as +12065550100. The address for the email channel is an email address.
     */
    public val address: kotlin.String? = builder.address
    /**
     * The unique identifier for the application that's associated with the endpoint.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments.
     */
    public val attributes: Map<String, List<String>>? = builder.attributes
    /**
     * The channel that's used when sending messages or push notifications to the endpoint.
     */
    public val channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = builder.channelType
    /**
     * A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped into cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an application. Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
     */
    public val cohortId: kotlin.String? = builder.cohortId
    /**
     * The date and time, in ISO 8601 format, when the endpoint was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The demographic information for the endpoint, such as the time zone and platform.
     */
    public val demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = builder.demographic
    /**
     * The date and time, in ISO 8601 format, when the endpoint was last updated.
     */
    public val effectiveDate: kotlin.String? = builder.effectiveDate
    /**
     * Specifies whether messages or push notifications are sent to the endpoint. Possible values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
     *
     * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
     */
    public val endpointStatus: kotlin.String? = builder.endpointStatus
    /**
     * The unique identifier that you assigned to the endpoint. The identifier should be a globally unique identifier (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are associated with the application.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The geographic information for the endpoint.
     */
    public val location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = builder.location
    /**
     * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     */
    public val metrics: Map<String, Double>? = builder.metrics
    /**
     * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
     */
    public val optOut: kotlin.String? = builder.optOut
    /**
     * The unique identifier for the most recent request to update the endpoint.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with the endpoint.
     */
    public val user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointResponse(")
        append("address=$address,")
        append("applicationId=$applicationId,")
        append("attributes=$attributes,")
        append("channelType=$channelType,")
        append("cohortId=$cohortId,")
        append("creationDate=$creationDate,")
        append("demographic=$demographic,")
        append("effectiveDate=$effectiveDate,")
        append("endpointStatus=$endpointStatus,")
        append("id=$id,")
        append("location=$location,")
        append("metrics=$metrics,")
        append("optOut=$optOut,")
        append("requestId=$requestId,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (channelType?.hashCode() ?: 0)
        result = 31 * result + (cohortId?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (demographic?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (optOut?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointResponse

        if (address != other.address) return false
        if (applicationId != other.applicationId) return false
        if (attributes != other.attributes) return false
        if (channelType != other.channelType) return false
        if (cohortId != other.cohortId) return false
        if (creationDate != other.creationDate) return false
        if (demographic != other.demographic) return false
        if (effectiveDate != other.effectiveDate) return false
        if (endpointStatus != other.endpointStatus) return false
        if (id != other.id) return false
        if (location != other.location) return false
        if (metrics != other.metrics) return false
        if (optOut != other.optOut) return false
        if (requestId != other.requestId) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EndpointResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For example, the address for a push-notification channel is typically the token provided by a push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. The address for the SMS channel is a phone number in E.164 format, such as +12065550100. The address for the email channel is an email address.
         */
        public var address: kotlin.String? = null
        /**
         * The unique identifier for the application that's associated with the endpoint.
         */
        public var applicationId: kotlin.String? = null
        /**
         * One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments.
         */
        public var attributes: Map<String, List<String>>? = null
        /**
         * The channel that's used when sending messages or push notifications to the endpoint.
         */
        public var channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = null
        /**
         * A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped into cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an application. Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
         */
        public var cohortId: kotlin.String? = null
        /**
         * The date and time, in ISO 8601 format, when the endpoint was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The demographic information for the endpoint, such as the time zone and platform.
         */
        public var demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = null
        /**
         * The date and time, in ISO 8601 format, when the endpoint was last updated.
         */
        public var effectiveDate: kotlin.String? = null
        /**
         * Specifies whether messages or push notifications are sent to the endpoint. Possible values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
         *
         * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
         */
        public var endpointStatus: kotlin.String? = null
        /**
         * The unique identifier that you assigned to the endpoint. The identifier should be a globally unique identifier (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are associated with the application.
         */
        public var id: kotlin.String? = null
        /**
         * The geographic information for the endpoint.
         */
        public var location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = null
        /**
         * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         */
        public var metrics: Map<String, Double>? = null
        /**
         * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
         */
        public var optOut: kotlin.String? = null
        /**
         * The unique identifier for the most recent request to update the endpoint.
         */
        public var requestId: kotlin.String? = null
        /**
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with the endpoint.
         */
        public var user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EndpointResponse) : this() {
            this.address = x.address
            this.applicationId = x.applicationId
            this.attributes = x.attributes
            this.channelType = x.channelType
            this.cohortId = x.cohortId
            this.creationDate = x.creationDate
            this.demographic = x.demographic
            this.effectiveDate = x.effectiveDate
            this.endpointStatus = x.endpointStatus
            this.id = x.id
            this.location = x.location
            this.metrics = x.metrics
            this.optOut = x.optOut
            this.requestId = x.requestId
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EndpointResponse = EndpointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic] inside the given [block]
         */
        public fun demographic(block: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.Builder.() -> kotlin.Unit) {
            this.demographic = aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointUser] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.pinpoint.model.EndpointUser.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.pinpoint.model.EndpointUser.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
