// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the channel type and other settings for an endpoint.
 */
public class EndpointRequest private constructor(builder: Builder) {
    /**
     * The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.
     */
    public val address: kotlin.String? = builder.address
    /**
     * One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.
     *
     * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.
     */
    public val attributes: Map<String, List<String>>? = builder.attributes
    /**
     * The channel to use when sending messages or push notifications to the endpoint.
     */
    public val channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = builder.channelType
    /**
     * The demographic information for the endpoint, such as the time zone and platform.
     */
    public val demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = builder.demographic
    /**
     * The date and time, in ISO 8601 format, when the endpoint is updated.
     */
    public val effectiveDate: kotlin.String? = builder.effectiveDate
    /**
     * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
     *
     * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
     */
    public val endpointStatus: kotlin.String? = builder.endpointStatus
    /**
     * The geographic information for the endpoint.
     */
    public val location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = builder.location
    /**
     * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     */
    public val metrics: Map<String, Double>? = builder.metrics
    /**
     * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
     */
    public val optOut: kotlin.String? = builder.optOut
    /**
     * The unique identifier for the most recent request to update the endpoint.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * One or more custom attributes that describe the user who's associated with the endpoint.
     */
    public val user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointRequest(")
        append("address=$address,")
        append("attributes=$attributes,")
        append("channelType=$channelType,")
        append("demographic=$demographic,")
        append("effectiveDate=$effectiveDate,")
        append("endpointStatus=$endpointStatus,")
        append("location=$location,")
        append("metrics=$metrics,")
        append("optOut=$optOut,")
        append("requestId=$requestId,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (channelType?.hashCode() ?: 0)
        result = 31 * result + (demographic?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (optOut?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointRequest

        if (address != other.address) return false
        if (attributes != other.attributes) return false
        if (channelType != other.channelType) return false
        if (demographic != other.demographic) return false
        if (effectiveDate != other.effectiveDate) return false
        if (endpointStatus != other.endpointStatus) return false
        if (location != other.location) return false
        if (metrics != other.metrics) return false
        if (optOut != other.optOut) return false
        if (requestId != other.requestId) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.
         */
        public var address: kotlin.String? = null
        /**
         * One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: &#91;"Science", "Music", "Travel"&#93;. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.
         *
         * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain these characters. This restriction doesn't apply to attribute values.
         */
        public var attributes: Map<String, List<String>>? = null
        /**
         * The channel to use when sending messages or push notifications to the endpoint.
         */
        public var channelType: aws.sdk.kotlin.services.pinpoint.model.ChannelType? = null
        /**
         * The demographic information for the endpoint, such as the time zone and platform.
         */
        public var demographic: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic? = null
        /**
         * The date and time, in ISO 8601 format, when the endpoint is updated.
         */
        public var effectiveDate: kotlin.String? = null
        /**
         * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
         *
         * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.
         */
        public var endpointStatus: kotlin.String? = null
        /**
         * The geographic information for the endpoint.
         */
        public var location: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation? = null
        /**
         * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         */
        public var metrics: Map<String, Double>? = null
        /**
         * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push notifications.
         */
        public var optOut: kotlin.String? = null
        /**
         * The unique identifier for the most recent request to update the endpoint.
         */
        public var requestId: kotlin.String? = null
        /**
         * One or more custom attributes that describe the user who's associated with the endpoint.
         */
        public var user: aws.sdk.kotlin.services.pinpoint.model.EndpointUser? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EndpointRequest) : this() {
            this.address = x.address
            this.attributes = x.attributes
            this.channelType = x.channelType
            this.demographic = x.demographic
            this.effectiveDate = x.effectiveDate
            this.endpointStatus = x.endpointStatus
            this.location = x.location
            this.metrics = x.metrics
            this.optOut = x.optOut
            this.requestId = x.requestId
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EndpointRequest = EndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic] inside the given [block]
         */
        public fun demographic(block: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.Builder.() -> kotlin.Unit) {
            this.demographic = aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.pinpoint.model.EndpointLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EndpointUser] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.pinpoint.model.EndpointUser.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.pinpoint.model.EndpointUser.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
