// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the status and settings of the email channel for an application.
 */
public class EmailChannelResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the email channel applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The [Amazon SES configuration set](https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html) that's applied to messages that are sent through the channel.
     */
    public val configurationSet: kotlin.String? = builder.configurationSet
    /**
     * The date and time, in ISO 8601 format, when the email channel was enabled.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * Specifies whether the email channel is enabled for the application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The verified email address that email is sent from when you send email through the channel.
     */
    public val fromAddress: kotlin.String? = builder.fromAddress
    /**
     * (Not used) This property is retained only for backward compatibility.
     */
    public val hasCredential: kotlin.Boolean? = builder.hasCredential
    /**
     * (Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * Specifies whether the email channel is archived.
     */
    public val isArchived: kotlin.Boolean? = builder.isArchived
    /**
     * The user who last modified the email channel.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time, in ISO 8601 format, when the email channel was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The maximum number of emails that can be sent through the channel each second.
     */
    public val messagesPerSecond: kotlin.Int? = builder.messagesPerSecond
    /**
     * The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current version of the email channel.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EmailChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailChannelResponse(")
        append("applicationId=$applicationId,")
        append("configurationSet=$configurationSet,")
        append("creationDate=$creationDate,")
        append("enabled=$enabled,")
        append("fromAddress=$fromAddress,")
        append("hasCredential=$hasCredential,")
        append("id=$id,")
        append("identity=$identity,")
        append("isArchived=$isArchived,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("messagesPerSecond=$messagesPerSecond,")
        append("platform=$platform,")
        append("roleArn=$roleArn,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (configurationSet?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (fromAddress?.hashCode() ?: 0)
        result = 31 * result + (hasCredential?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (isArchived?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (messagesPerSecond ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailChannelResponse

        if (applicationId != other.applicationId) return false
        if (configurationSet != other.configurationSet) return false
        if (creationDate != other.creationDate) return false
        if (enabled != other.enabled) return false
        if (fromAddress != other.fromAddress) return false
        if (hasCredential != other.hasCredential) return false
        if (id != other.id) return false
        if (identity != other.identity) return false
        if (isArchived != other.isArchived) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (messagesPerSecond != other.messagesPerSecond) return false
        if (platform != other.platform) return false
        if (roleArn != other.roleArn) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EmailChannelResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that the email channel applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The [Amazon SES configuration set](https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html) that's applied to messages that are sent through the channel.
         */
        public var configurationSet: kotlin.String? = null
        /**
         * The date and time, in ISO 8601 format, when the email channel was enabled.
         */
        public var creationDate: kotlin.String? = null
        /**
         * Specifies whether the email channel is enabled for the application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The verified email address that email is sent from when you send email through the channel.
         */
        public var fromAddress: kotlin.String? = null
        /**
         * (Not used) This property is retained only for backward compatibility.
         */
        public var hasCredential: kotlin.Boolean? = null
        /**
         * (Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's used when you send email through the channel.
         */
        public var identity: kotlin.String? = null
        /**
         * Specifies whether the email channel is archived.
         */
        public var isArchived: kotlin.Boolean? = null
        /**
         * The user who last modified the email channel.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time, in ISO 8601 format, when the email channel was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The maximum number of emails that can be sent through the channel each second.
         */
        public var messagesPerSecond: kotlin.Int? = null
        /**
         * The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.
         */
        public var platform: kotlin.String? = null
        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The current version of the email channel.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EmailChannelResponse) : this() {
            this.applicationId = x.applicationId
            this.configurationSet = x.configurationSet
            this.creationDate = x.creationDate
            this.enabled = x.enabled
            this.fromAddress = x.fromAddress
            this.hasCredential = x.hasCredential
            this.id = x.id
            this.identity = x.identity
            this.isArchived = x.isArchived
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedDate = x.lastModifiedDate
            this.messagesPerSecond = x.messagesPerSecond
            this.platform = x.platform
            this.roleArn = x.roleArn
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EmailChannelResponse = EmailChannelResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
