// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the status and settings of the email channel for an application.
 */
public class EmailChannelRequest private constructor(builder: Builder) {
    /**
     * The [Amazon SES configuration set](https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html) that you want to apply to messages that you send through the channel.
     */
    public val configurationSet: kotlin.String? = builder.configurationSet
    /**
     * Specifies whether to enable the email channel for the application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The verified email address that you want to send email from when you send email through the channel.
     */
    public val fromAddress: kotlin.String? = builder.fromAddress
    /**
     * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EmailChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailChannelRequest(")
        append("configurationSet=$configurationSet,")
        append("enabled=$enabled,")
        append("fromAddress=$fromAddress,")
        append("identity=$identity,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSet?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (fromAddress?.hashCode() ?: 0)
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailChannelRequest

        if (configurationSet != other.configurationSet) return false
        if (enabled != other.enabled) return false
        if (fromAddress != other.fromAddress) return false
        if (identity != other.identity) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EmailChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [Amazon SES configuration set](https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html) that you want to apply to messages that you send through the channel.
         */
        public var configurationSet: kotlin.String? = null
        /**
         * Specifies whether to enable the email channel for the application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The verified email address that you want to send email from when you send email through the channel.
         */
        public var fromAddress: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.
         */
        public var identity: kotlin.String? = null
        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EmailChannelRequest) : this() {
            this.configurationSet = x.configurationSet
            this.enabled = x.enabled
            this.fromAddress = x.fromAddress
            this.identity = x.identity
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EmailChannelRequest = EmailChannelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
