// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings and content for the default message and any default messages that you tailored for specific channels.
 */
public class DirectMessageConfiguration private constructor(builder: Builder) {
    /**
     * The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public val admMessage: aws.sdk.kotlin.services.pinpoint.model.AdmMessage? = builder.admMessage
    /**
     * The default push notification message for the APNs (Apple Push Notification service) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public val apnsMessage: aws.sdk.kotlin.services.pinpoint.model.ApnsMessage? = builder.apnsMessage
    /**
     * The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public val baiduMessage: aws.sdk.kotlin.services.pinpoint.model.BaiduMessage? = builder.baiduMessage
    /**
     * The default message for all channels.
     */
    public val defaultMessage: aws.sdk.kotlin.services.pinpoint.model.DefaultMessage? = builder.defaultMessage
    /**
     * The default push notification message for all push notification channels.
     */
    public val defaultPushNotificationMessage: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage? = builder.defaultPushNotificationMessage
    /**
     * The default message for the email channel. This message overrides the default message (DefaultMessage).
     */
    public val emailMessage: aws.sdk.kotlin.services.pinpoint.model.EmailMessage? = builder.emailMessage
    /**
     * The default push notification message for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the default push notification message (DefaultPushNotificationMessage).
     */
    public val gcmMessage: aws.sdk.kotlin.services.pinpoint.model.GcmMessage? = builder.gcmMessage
    /**
     * The default message for the SMS channel. This message overrides the default message (DefaultMessage).
     */
    public val smsMessage: aws.sdk.kotlin.services.pinpoint.model.SmsMessage? = builder.smsMessage
    /**
     * The default message for the voice channel. This message overrides the default message (DefaultMessage).
     */
    public val voiceMessage: aws.sdk.kotlin.services.pinpoint.model.VoiceMessage? = builder.voiceMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectMessageConfiguration(")
        append("admMessage=$admMessage,")
        append("apnsMessage=$apnsMessage,")
        append("baiduMessage=$baiduMessage,")
        append("defaultMessage=$defaultMessage,")
        append("defaultPushNotificationMessage=$defaultPushNotificationMessage,")
        append("emailMessage=$emailMessage,")
        append("gcmMessage=$gcmMessage,")
        append("smsMessage=$smsMessage,")
        append("voiceMessage=$voiceMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = admMessage?.hashCode() ?: 0
        result = 31 * result + (apnsMessage?.hashCode() ?: 0)
        result = 31 * result + (baiduMessage?.hashCode() ?: 0)
        result = 31 * result + (defaultMessage?.hashCode() ?: 0)
        result = 31 * result + (defaultPushNotificationMessage?.hashCode() ?: 0)
        result = 31 * result + (emailMessage?.hashCode() ?: 0)
        result = 31 * result + (gcmMessage?.hashCode() ?: 0)
        result = 31 * result + (smsMessage?.hashCode() ?: 0)
        result = 31 * result + (voiceMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectMessageConfiguration

        if (admMessage != other.admMessage) return false
        if (apnsMessage != other.apnsMessage) return false
        if (baiduMessage != other.baiduMessage) return false
        if (defaultMessage != other.defaultMessage) return false
        if (defaultPushNotificationMessage != other.defaultPushNotificationMessage) return false
        if (emailMessage != other.emailMessage) return false
        if (gcmMessage != other.gcmMessage) return false
        if (smsMessage != other.smsMessage) return false
        if (voiceMessage != other.voiceMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
         */
        public var admMessage: aws.sdk.kotlin.services.pinpoint.model.AdmMessage? = null
        /**
         * The default push notification message for the APNs (Apple Push Notification service) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
         */
        public var apnsMessage: aws.sdk.kotlin.services.pinpoint.model.ApnsMessage? = null
        /**
         * The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
         */
        public var baiduMessage: aws.sdk.kotlin.services.pinpoint.model.BaiduMessage? = null
        /**
         * The default message for all channels.
         */
        public var defaultMessage: aws.sdk.kotlin.services.pinpoint.model.DefaultMessage? = null
        /**
         * The default push notification message for all push notification channels.
         */
        public var defaultPushNotificationMessage: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage? = null
        /**
         * The default message for the email channel. This message overrides the default message (DefaultMessage).
         */
        public var emailMessage: aws.sdk.kotlin.services.pinpoint.model.EmailMessage? = null
        /**
         * The default push notification message for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the default push notification message (DefaultPushNotificationMessage).
         */
        public var gcmMessage: aws.sdk.kotlin.services.pinpoint.model.GcmMessage? = null
        /**
         * The default message for the SMS channel. This message overrides the default message (DefaultMessage).
         */
        public var smsMessage: aws.sdk.kotlin.services.pinpoint.model.SmsMessage? = null
        /**
         * The default message for the voice channel. This message overrides the default message (DefaultMessage).
         */
        public var voiceMessage: aws.sdk.kotlin.services.pinpoint.model.VoiceMessage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration) : this() {
            this.admMessage = x.admMessage
            this.apnsMessage = x.apnsMessage
            this.baiduMessage = x.baiduMessage
            this.defaultMessage = x.defaultMessage
            this.defaultPushNotificationMessage = x.defaultPushNotificationMessage
            this.emailMessage = x.emailMessage
            this.gcmMessage = x.gcmMessage
            this.smsMessage = x.smsMessage
            this.voiceMessage = x.voiceMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration = DirectMessageConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AdmMessage] inside the given [block]
         */
        public fun admMessage(block: aws.sdk.kotlin.services.pinpoint.model.AdmMessage.Builder.() -> kotlin.Unit) {
            this.admMessage = aws.sdk.kotlin.services.pinpoint.model.AdmMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ApnsMessage] inside the given [block]
         */
        public fun apnsMessage(block: aws.sdk.kotlin.services.pinpoint.model.ApnsMessage.Builder.() -> kotlin.Unit) {
            this.apnsMessage = aws.sdk.kotlin.services.pinpoint.model.ApnsMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.BaiduMessage] inside the given [block]
         */
        public fun baiduMessage(block: aws.sdk.kotlin.services.pinpoint.model.BaiduMessage.Builder.() -> kotlin.Unit) {
            this.baiduMessage = aws.sdk.kotlin.services.pinpoint.model.BaiduMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DefaultMessage] inside the given [block]
         */
        public fun defaultMessage(block: aws.sdk.kotlin.services.pinpoint.model.DefaultMessage.Builder.() -> kotlin.Unit) {
            this.defaultMessage = aws.sdk.kotlin.services.pinpoint.model.DefaultMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage] inside the given [block]
         */
        public fun defaultPushNotificationMessage(block: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage.Builder.() -> kotlin.Unit) {
            this.defaultPushNotificationMessage = aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.EmailMessage] inside the given [block]
         */
        public fun emailMessage(block: aws.sdk.kotlin.services.pinpoint.model.EmailMessage.Builder.() -> kotlin.Unit) {
            this.emailMessage = aws.sdk.kotlin.services.pinpoint.model.EmailMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.GcmMessage] inside the given [block]
         */
        public fun gcmMessage(block: aws.sdk.kotlin.services.pinpoint.model.GcmMessage.Builder.() -> kotlin.Unit) {
            this.gcmMessage = aws.sdk.kotlin.services.pinpoint.model.GcmMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SmsMessage] inside the given [block]
         */
        public fun smsMessage(block: aws.sdk.kotlin.services.pinpoint.model.SmsMessage.Builder.() -> kotlin.Unit) {
            this.smsMessage = aws.sdk.kotlin.services.pinpoint.model.SmsMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.VoiceMessage] inside the given [block]
         */
        public fun voiceMessage(block: aws.sdk.kotlin.services.pinpoint.model.VoiceMessage.Builder.() -> kotlin.Unit) {
            this.voiceMessage = aws.sdk.kotlin.services.pinpoint.model.VoiceMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
