// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a yes/no split activity in a journey. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.
 *
 * To create yes/no split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see [Integrating Amazon Pinpoint with your application](https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html) in the *Amazon Pinpoint Developer Guide*.
 */
public class ConditionalSplitActivity private constructor(builder: Builder) {
    /**
     * The conditions that define the paths for the activity, and the relationship between the conditions.
     */
    public val condition: aws.sdk.kotlin.services.pinpoint.model.Condition? = builder.condition
    /**
     * The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.
     */
    public val evaluationWaitTime: aws.sdk.kotlin.services.pinpoint.model.WaitTime? = builder.evaluationWaitTime
    /**
     * The unique identifier for the activity to perform if the conditions aren't met.
     */
    public val falseActivity: kotlin.String? = builder.falseActivity
    /**
     * The unique identifier for the activity to perform if the conditions are met.
     */
    public val trueActivity: kotlin.String? = builder.trueActivity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ConditionalSplitActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConditionalSplitActivity(")
        append("condition=$condition,")
        append("evaluationWaitTime=$evaluationWaitTime,")
        append("falseActivity=$falseActivity,")
        append("trueActivity=$trueActivity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (evaluationWaitTime?.hashCode() ?: 0)
        result = 31 * result + (falseActivity?.hashCode() ?: 0)
        result = 31 * result + (trueActivity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConditionalSplitActivity

        if (condition != other.condition) return false
        if (evaluationWaitTime != other.evaluationWaitTime) return false
        if (falseActivity != other.falseActivity) return false
        if (trueActivity != other.trueActivity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ConditionalSplitActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The conditions that define the paths for the activity, and the relationship between the conditions.
         */
        public var condition: aws.sdk.kotlin.services.pinpoint.model.Condition? = null
        /**
         * The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.
         */
        public var evaluationWaitTime: aws.sdk.kotlin.services.pinpoint.model.WaitTime? = null
        /**
         * The unique identifier for the activity to perform if the conditions aren't met.
         */
        public var falseActivity: kotlin.String? = null
        /**
         * The unique identifier for the activity to perform if the conditions are met.
         */
        public var trueActivity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ConditionalSplitActivity) : this() {
            this.condition = x.condition
            this.evaluationWaitTime = x.evaluationWaitTime
            this.falseActivity = x.falseActivity
            this.trueActivity = x.trueActivity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ConditionalSplitActivity = ConditionalSplitActivity(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Condition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.pinpoint.model.Condition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.pinpoint.model.Condition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.WaitTime] inside the given [block]
         */
        public fun evaluationWaitTime(block: aws.sdk.kotlin.services.pinpoint.model.WaitTime.Builder.() -> kotlin.Unit) {
            this.evaluationWaitTime = aws.sdk.kotlin.services.pinpoint.model.WaitTime.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
