// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the status, configuration, and other settings for a campaign.
 */
public class CampaignResponse private constructor(builder: Builder) {
    /**
     * An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.
     */
    public val additionalTreatments: List<TreatmentResource>? = builder.additionalTreatments
    /**
     * The unique identifier for the application that the campaign applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the campaign.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date, in ISO 8601 format, when the campaign was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The delivery configuration settings for sending the campaign through a custom channel.
     */
    public val customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = builder.customDeliveryConfiguration
    /**
     * The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.
     */
    public val defaultState: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = builder.defaultState
    /**
     * The custom description of the campaign.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    public val holdoutPercent: kotlin.Int? = builder.holdoutPercent
    /**
     * The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.
     */
    public val hook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = builder.hook
    /**
     * The unique identifier for the campaign.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.
     */
    public val isPaused: kotlin.Boolean? = builder.isPaused
    /**
     * The date, in ISO 8601 format, when the campaign was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The messaging limits for the campaign.
     */
    public val limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = builder.limits
    /**
     * The message configuration settings for the campaign.
     */
    public val messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = builder.messageConfiguration
    /**
     * The name of the campaign.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The schedule settings for the campaign.
     */
    public val schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = builder.schedule
    /**
     * The unique identifier for the segment that's associated with the campaign.
     */
    public val segmentId: kotlin.String? = builder.segmentId
    /**
     * The version number of the segment that's associated with the campaign.
     */
    public val segmentVersion: kotlin.Int? = builder.segmentVersion
    /**
     * The current status of the campaign.
     */
    public val state: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = builder.state
    /**
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The message template that’s used for the campaign.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * The custom description of the default treatment for the campaign.
     */
    public val treatmentDescription: kotlin.String? = builder.treatmentDescription
    /**
     * The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A *treatment* is a variation of a campaign that's used for A/B testing.
     */
    public val treatmentName: kotlin.String? = builder.treatmentName
    /**
     * The version number of the campaign.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CampaignResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignResponse(")
        append("additionalTreatments=$additionalTreatments,")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("customDeliveryConfiguration=$customDeliveryConfiguration,")
        append("defaultState=$defaultState,")
        append("description=$description,")
        append("holdoutPercent=$holdoutPercent,")
        append("hook=$hook,")
        append("id=$id,")
        append("isPaused=$isPaused,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("limits=$limits,")
        append("messageConfiguration=$messageConfiguration,")
        append("name=$name,")
        append("priority=$priority,")
        append("schedule=$schedule,")
        append("segmentId=$segmentId,")
        append("segmentVersion=$segmentVersion,")
        append("state=$state,")
        append("tags=$tags,")
        append("templateConfiguration=$templateConfiguration,")
        append("treatmentDescription=$treatmentDescription,")
        append("treatmentName=$treatmentName,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalTreatments?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (defaultState?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (holdoutPercent ?: 0)
        result = 31 * result + (hook?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isPaused?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (messageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (segmentId?.hashCode() ?: 0)
        result = 31 * result + (segmentVersion ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (treatmentDescription?.hashCode() ?: 0)
        result = 31 * result + (treatmentName?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignResponse

        if (additionalTreatments != other.additionalTreatments) return false
        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (customDeliveryConfiguration != other.customDeliveryConfiguration) return false
        if (defaultState != other.defaultState) return false
        if (description != other.description) return false
        if (holdoutPercent != other.holdoutPercent) return false
        if (hook != other.hook) return false
        if (id != other.id) return false
        if (isPaused != other.isPaused) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (limits != other.limits) return false
        if (messageConfiguration != other.messageConfiguration) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (schedule != other.schedule) return false
        if (segmentId != other.segmentId) return false
        if (segmentVersion != other.segmentVersion) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (treatmentDescription != other.treatmentDescription) return false
        if (treatmentName != other.treatmentName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CampaignResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.
         */
        public var additionalTreatments: List<TreatmentResource>? = null
        /**
         * The unique identifier for the application that the campaign applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the campaign.
         */
        public var arn: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the campaign was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The delivery configuration settings for sending the campaign through a custom channel.
         */
        public var customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = null
        /**
         * The current status of the campaign's default treatment. This value exists only for campaigns that have more than one treatment.
         */
        public var defaultState: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = null
        /**
         * The custom description of the campaign.
         */
        public var description: kotlin.String? = null
        /**
         * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         */
        public var holdoutPercent: kotlin.Int? = null
        /**
         * The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that's used by the campaign.
         */
        public var hook: aws.sdk.kotlin.services.pinpoint.model.CampaignHook? = null
        /**
         * The unique identifier for the campaign.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this value to false.
         */
        public var isPaused: kotlin.Boolean? = null
        /**
         * The date, in ISO 8601 format, when the campaign was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The messaging limits for the campaign.
         */
        public var limits: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits? = null
        /**
         * The message configuration settings for the campaign.
         */
        public var messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = null
        /**
         * The name of the campaign.
         */
        public var name: kotlin.String? = null
        /**
         * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.
         */
        public var priority: kotlin.Int? = null
        /**
         * The schedule settings for the campaign.
         */
        public var schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = null
        /**
         * The unique identifier for the segment that's associated with the campaign.
         */
        public var segmentId: kotlin.String? = null
        /**
         * The version number of the segment that's associated with the campaign.
         */
        public var segmentVersion: kotlin.Int? = null
        /**
         * The current status of the campaign.
         */
        public var state: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = null
        /**
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * The message template that’s used for the campaign.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = null
        /**
         * The custom description of the default treatment for the campaign.
         */
        public var treatmentDescription: kotlin.String? = null
        /**
         * The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A *treatment* is a variation of a campaign that's used for A/B testing.
         */
        public var treatmentName: kotlin.String? = null
        /**
         * The version number of the campaign.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CampaignResponse) : this() {
            this.additionalTreatments = x.additionalTreatments
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.customDeliveryConfiguration = x.customDeliveryConfiguration
            this.defaultState = x.defaultState
            this.description = x.description
            this.holdoutPercent = x.holdoutPercent
            this.hook = x.hook
            this.id = x.id
            this.isPaused = x.isPaused
            this.lastModifiedDate = x.lastModifiedDate
            this.limits = x.limits
            this.messageConfiguration = x.messageConfiguration
            this.name = x.name
            this.priority = x.priority
            this.schedule = x.schedule
            this.segmentId = x.segmentId
            this.segmentVersion = x.segmentVersion
            this.state = x.state
            this.tags = x.tags
            this.templateConfiguration = x.templateConfiguration
            this.treatmentDescription = x.treatmentDescription
            this.treatmentName = x.treatmentName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CampaignResponse = CampaignResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration] inside the given [block]
         */
        public fun customDeliveryConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.customDeliveryConfiguration = aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignState] inside the given [block]
         */
        public fun defaultState(block: aws.sdk.kotlin.services.pinpoint.model.CampaignState.Builder.() -> kotlin.Unit) {
            this.defaultState = aws.sdk.kotlin.services.pinpoint.model.CampaignState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignHook] inside the given [block]
         */
        public fun hook(block: aws.sdk.kotlin.services.pinpoint.model.CampaignHook.Builder.() -> kotlin.Unit) {
            this.hook = aws.sdk.kotlin.services.pinpoint.model.CampaignHook.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignLimits] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.pinpoint.model.CampaignLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration] inside the given [block]
         */
        public fun messageConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.Builder.() -> kotlin.Unit) {
            this.messageConfiguration = aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.pinpoint.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.pinpoint.model.Schedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.pinpoint.model.CampaignState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.pinpoint.model.CampaignState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
