// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies attribute-based criteria for including or excluding endpoints from a segment.
 */
public class AttributeDimension private constructor(builder: Builder) {
    /**
     * The type of segment dimension to use. Valid values are:
     * + INCLUSIVE - endpoints that have attributes matching the values are included in the segment.
     * + EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.
     * + CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.
     * + BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.
     * + AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.
     * + ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.
     * + BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.
     */
    public val attributeType: aws.sdk.kotlin.services.pinpoint.model.AttributeType? = builder.attributeType
    /**
     * The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.AttributeDimension = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeDimension(")
        append("attributeType=$attributeType,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeType?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeDimension

        if (attributeType != other.attributeType) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.AttributeDimension = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of segment dimension to use. Valid values are:
         * + INCLUSIVE - endpoints that have attributes matching the values are included in the segment.
         * + EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.
         * + CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.
         * + BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.
         * + AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.
         * + ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.
         * + BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.
         */
        public var attributeType: aws.sdk.kotlin.services.pinpoint.model.AttributeType? = null
        /**
         * The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.AttributeDimension) : this() {
            this.attributeType = x.attributeType
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.AttributeDimension = AttributeDimension(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
