// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides the results of a query that retrieved the data for a standard metric that applies to an application, and provides information about that query.
 */
public class ApplicationDateRangeKpiResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the metric applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The name of the metric, also referred to as a *key performance indicator (KPI)*, that the data was retrieved for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the [Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
     */
    public val kpiName: kotlin.String? = builder.kpiName
    /**
     * An array of objects that contains the results of the query. Each object contains the value for the metric and metadata about that value.
     */
    public val kpiResult: aws.sdk.kotlin.services.pinpoint.model.BaseKpiResult? = builder.kpiResult
    /**
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is null for the Application Metrics resource because the resource returns all results in a single page.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApplicationDateRangeKpiResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationDateRangeKpiResponse(")
        append("applicationId=$applicationId,")
        append("endTime=$endTime,")
        append("kpiName=$kpiName,")
        append("kpiResult=$kpiResult,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (kpiName?.hashCode() ?: 0)
        result = 31 * result + (kpiResult?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationDateRangeKpiResponse

        if (applicationId != other.applicationId) return false
        if (endTime != other.endTime) return false
        if (kpiName != other.kpiName) return false
        if (kpiResult != other.kpiResult) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApplicationDateRangeKpiResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that the metric applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the metric, also referred to as a *key performance indicator (KPI)*, that the data was retrieved for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the [Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
         */
        public var kpiName: kotlin.String? = null
        /**
         * An array of objects that contains the results of the query. Each object contains the value for the metric and metadata about that value.
         */
        public var kpiResult: aws.sdk.kotlin.services.pinpoint.model.BaseKpiResult? = null
        /**
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value is null for the Application Metrics resource because the resource returns all results in a single page.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApplicationDateRangeKpiResponse) : this() {
            this.applicationId = x.applicationId
            this.endTime = x.endTime
            this.kpiName = x.kpiName
            this.kpiResult = x.kpiResult
            this.nextToken = x.nextToken
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApplicationDateRangeKpiResponse = ApplicationDateRangeKpiResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.BaseKpiResult] inside the given [block]
         */
        public fun kpiResult(block: aws.sdk.kotlin.services.pinpoint.model.BaseKpiResult.Builder.() -> kotlin.Unit) {
            this.kpiResult = aws.sdk.kotlin.services.pinpoint.model.BaseKpiResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
