// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.pinpoint.auth.PinpointAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.pinpoint.auth.PinpointIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.pinpoint.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.pinpoint.model.*
import aws.sdk.kotlin.services.pinpoint.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultPinpointClient(override val config: PinpointClient.Config) : PinpointClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = PinpointIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "mobiletargeting")
        }
        toMap()
    }
    private val authSchemeAdapter = PinpointAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.pinpoint"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates an application.
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            operationName = "CreateApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializer = CreateCampaignOperationSerializer()
            deserializer = CreateCampaignOperationDeserializer()
            operationName = "CreateCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a message template for messages that are sent through the email channel.
     */
    override suspend fun createEmailTemplate(input: CreateEmailTemplateRequest): CreateEmailTemplateResponse {
        val op = SdkHttpOperation.build<CreateEmailTemplateRequest, CreateEmailTemplateResponse> {
            serializer = CreateEmailTemplateOperationSerializer()
            deserializer = CreateEmailTemplateOperationDeserializer()
            operationName = "CreateEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an export job for an application.
     */
    override suspend fun createExportJob(input: CreateExportJobRequest): CreateExportJobResponse {
        val op = SdkHttpOperation.build<CreateExportJobRequest, CreateExportJobResponse> {
            serializer = CreateExportJobOperationSerializer()
            deserializer = CreateExportJobOperationDeserializer()
            operationName = "CreateExportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an import job for an application.
     */
    override suspend fun createImportJob(input: CreateImportJobRequest): CreateImportJobResponse {
        val op = SdkHttpOperation.build<CreateImportJobRequest, CreateImportJobResponse> {
            serializer = CreateImportJobOperationSerializer()
            deserializer = CreateImportJobOperationDeserializer()
            operationName = "CreateImportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new message template for messages using the in-app message channel.
     */
    override suspend fun createInAppTemplate(input: CreateInAppTemplateRequest): CreateInAppTemplateResponse {
        val op = SdkHttpOperation.build<CreateInAppTemplateRequest, CreateInAppTemplateResponse> {
            serializer = CreateInAppTemplateOperationSerializer()
            deserializer = CreateInAppTemplateOperationDeserializer()
            operationName = "CreateInAppTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a journey for an application.
     */
    override suspend fun createJourney(input: CreateJourneyRequest): CreateJourneyResponse {
        val op = SdkHttpOperation.build<CreateJourneyRequest, CreateJourneyResponse> {
            serializer = CreateJourneyOperationSerializer()
            deserializer = CreateJourneyOperationDeserializer()
            operationName = "CreateJourney"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a message template for messages that are sent through a push notification channel.
     */
    override suspend fun createPushTemplate(input: CreatePushTemplateRequest): CreatePushTemplateResponse {
        val op = SdkHttpOperation.build<CreatePushTemplateRequest, CreatePushTemplateResponse> {
            serializer = CreatePushTemplateOperationSerializer()
            deserializer = CreatePushTemplateOperationDeserializer()
            operationName = "CreatePushTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun createRecommenderConfiguration(input: CreateRecommenderConfigurationRequest): CreateRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<CreateRecommenderConfigurationRequest, CreateRecommenderConfigurationResponse> {
            serializer = CreateRecommenderConfigurationOperationSerializer()
            deserializer = CreateRecommenderConfigurationOperationDeserializer()
            operationName = "CreateRecommenderConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    override suspend fun createSegment(input: CreateSegmentRequest): CreateSegmentResponse {
        val op = SdkHttpOperation.build<CreateSegmentRequest, CreateSegmentResponse> {
            serializer = CreateSegmentOperationSerializer()
            deserializer = CreateSegmentOperationDeserializer()
            operationName = "CreateSegment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a message template for messages that are sent through the SMS channel.
     */
    override suspend fun createSmsTemplate(input: CreateSmsTemplateRequest): CreateSmsTemplateResponse {
        val op = SdkHttpOperation.build<CreateSmsTemplateRequest, CreateSmsTemplateResponse> {
            serializer = CreateSmsTemplateOperationSerializer()
            deserializer = CreateSmsTemplateOperationDeserializer()
            operationName = "CreateSmsTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a message template for messages that are sent through the voice channel.
     */
    override suspend fun createVoiceTemplate(input: CreateVoiceTemplateRequest): CreateVoiceTemplateResponse {
        val op = SdkHttpOperation.build<CreateVoiceTemplateRequest, CreateVoiceTemplateResponse> {
            serializer = CreateVoiceTemplateOperationSerializer()
            deserializer = CreateVoiceTemplateOperationDeserializer()
            operationName = "CreateVoiceTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteAdmChannel(input: DeleteAdmChannelRequest): DeleteAdmChannelResponse {
        val op = SdkHttpOperation.build<DeleteAdmChannelRequest, DeleteAdmChannelResponse> {
            serializer = DeleteAdmChannelOperationSerializer()
            deserializer = DeleteAdmChannelOperationDeserializer()
            operationName = "DeleteAdmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsChannel(input: DeleteApnsChannelRequest): DeleteApnsChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsChannelRequest, DeleteApnsChannelResponse> {
            serializer = DeleteApnsChannelOperationSerializer()
            deserializer = DeleteApnsChannelOperationDeserializer()
            operationName = "DeleteApnsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsSandboxChannel(input: DeleteApnsSandboxChannelRequest): DeleteApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse> {
            serializer = DeleteApnsSandboxChannelOperationSerializer()
            deserializer = DeleteApnsSandboxChannelOperationDeserializer()
            operationName = "DeleteApnsSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsVoipChannel(input: DeleteApnsVoipChannelRequest): DeleteApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse> {
            serializer = DeleteApnsVoipChannelOperationSerializer()
            deserializer = DeleteApnsVoipChannelOperationDeserializer()
            operationName = "DeleteApnsVoipChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsVoipSandboxChannel(input: DeleteApnsVoipSandboxChannelRequest): DeleteApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse> {
            serializer = DeleteApnsVoipSandboxChannelOperationSerializer()
            deserializer = DeleteApnsVoipSandboxChannelOperationDeserializer()
            operationName = "DeleteApnsVoipSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an application.
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            operationName = "DeleteApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteBaiduChannel(input: DeleteBaiduChannelRequest): DeleteBaiduChannelResponse {
        val op = SdkHttpOperation.build<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse> {
            serializer = DeleteBaiduChannelOperationSerializer()
            deserializer = DeleteBaiduChannelOperationDeserializer()
            operationName = "DeleteBaiduChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a campaign from an application.
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializer = DeleteCampaignOperationSerializer()
            deserializer = DeleteCampaignOperationDeserializer()
            operationName = "DeleteCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the email channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteEmailChannel(input: DeleteEmailChannelRequest): DeleteEmailChannelResponse {
        val op = SdkHttpOperation.build<DeleteEmailChannelRequest, DeleteEmailChannelResponse> {
            serializer = DeleteEmailChannelOperationSerializer()
            deserializer = DeleteEmailChannelOperationDeserializer()
            operationName = "DeleteEmailChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a message template for messages that were sent through the email channel.
     */
    override suspend fun deleteEmailTemplate(input: DeleteEmailTemplateRequest): DeleteEmailTemplateResponse {
        val op = SdkHttpOperation.build<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse> {
            serializer = DeleteEmailTemplateOperationSerializer()
            deserializer = DeleteEmailTemplateOperationDeserializer()
            operationName = "DeleteEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an endpoint from an application.
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            operationName = "DeleteEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the event stream for an application.
     */
    override suspend fun deleteEventStream(input: DeleteEventStreamRequest): DeleteEventStreamResponse {
        val op = SdkHttpOperation.build<DeleteEventStreamRequest, DeleteEventStreamResponse> {
            serializer = DeleteEventStreamOperationSerializer()
            deserializer = DeleteEventStreamOperationDeserializer()
            operationName = "DeleteEventStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteGcmChannel(input: DeleteGcmChannelRequest): DeleteGcmChannelResponse {
        val op = SdkHttpOperation.build<DeleteGcmChannelRequest, DeleteGcmChannelResponse> {
            serializer = DeleteGcmChannelOperationSerializer()
            deserializer = DeleteGcmChannelOperationDeserializer()
            operationName = "DeleteGcmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a message template for messages sent using the in-app message channel.
     */
    override suspend fun deleteInAppTemplate(input: DeleteInAppTemplateRequest): DeleteInAppTemplateResponse {
        val op = SdkHttpOperation.build<DeleteInAppTemplateRequest, DeleteInAppTemplateResponse> {
            serializer = DeleteInAppTemplateOperationSerializer()
            deserializer = DeleteInAppTemplateOperationDeserializer()
            operationName = "DeleteInAppTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a journey from an application.
     */
    override suspend fun deleteJourney(input: DeleteJourneyRequest): DeleteJourneyResponse {
        val op = SdkHttpOperation.build<DeleteJourneyRequest, DeleteJourneyResponse> {
            serializer = DeleteJourneyOperationSerializer()
            deserializer = DeleteJourneyOperationDeserializer()
            operationName = "DeleteJourney"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a message template for messages that were sent through a push notification channel.
     */
    override suspend fun deletePushTemplate(input: DeletePushTemplateRequest): DeletePushTemplateResponse {
        val op = SdkHttpOperation.build<DeletePushTemplateRequest, DeletePushTemplateResponse> {
            serializer = DeletePushTemplateOperationSerializer()
            deserializer = DeletePushTemplateOperationDeserializer()
            operationName = "DeletePushTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun deleteRecommenderConfiguration(input: DeleteRecommenderConfigurationRequest): DeleteRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteRecommenderConfigurationRequest, DeleteRecommenderConfigurationResponse> {
            serializer = DeleteRecommenderConfigurationOperationSerializer()
            deserializer = DeleteRecommenderConfigurationOperationDeserializer()
            operationName = "DeleteRecommenderConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a segment from an application.
     */
    override suspend fun deleteSegment(input: DeleteSegmentRequest): DeleteSegmentResponse {
        val op = SdkHttpOperation.build<DeleteSegmentRequest, DeleteSegmentResponse> {
            serializer = DeleteSegmentOperationSerializer()
            deserializer = DeleteSegmentOperationDeserializer()
            operationName = "DeleteSegment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteSmsChannel(input: DeleteSmsChannelRequest): DeleteSmsChannelResponse {
        val op = SdkHttpOperation.build<DeleteSmsChannelRequest, DeleteSmsChannelResponse> {
            serializer = DeleteSmsChannelOperationSerializer()
            deserializer = DeleteSmsChannelOperationDeserializer()
            operationName = "DeleteSmsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a message template for messages that were sent through the SMS channel.
     */
    override suspend fun deleteSmsTemplate(input: DeleteSmsTemplateRequest): DeleteSmsTemplateResponse {
        val op = SdkHttpOperation.build<DeleteSmsTemplateRequest, DeleteSmsTemplateResponse> {
            serializer = DeleteSmsTemplateOperationSerializer()
            deserializer = DeleteSmsTemplateOperationDeserializer()
            operationName = "DeleteSmsTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes all the endpoints that are associated with a specific user ID.
     */
    override suspend fun deleteUserEndpoints(input: DeleteUserEndpointsRequest): DeleteUserEndpointsResponse {
        val op = SdkHttpOperation.build<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse> {
            serializer = DeleteUserEndpointsOperationSerializer()
            deserializer = DeleteUserEndpointsOperationDeserializer()
            operationName = "DeleteUserEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteVoiceChannel(input: DeleteVoiceChannelRequest): DeleteVoiceChannelResponse {
        val op = SdkHttpOperation.build<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse> {
            serializer = DeleteVoiceChannelOperationSerializer()
            deserializer = DeleteVoiceChannelOperationDeserializer()
            operationName = "DeleteVoiceChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a message template for messages that were sent through the voice channel.
     */
    override suspend fun deleteVoiceTemplate(input: DeleteVoiceTemplateRequest): DeleteVoiceTemplateResponse {
        val op = SdkHttpOperation.build<DeleteVoiceTemplateRequest, DeleteVoiceTemplateResponse> {
            serializer = DeleteVoiceTemplateOperationSerializer()
            deserializer = DeleteVoiceTemplateOperationDeserializer()
            operationName = "DeleteVoiceTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the ADM channel for an application.
     */
    override suspend fun getAdmChannel(input: GetAdmChannelRequest): GetAdmChannelResponse {
        val op = SdkHttpOperation.build<GetAdmChannelRequest, GetAdmChannelResponse> {
            serializer = GetAdmChannelOperationSerializer()
            deserializer = GetAdmChannelOperationDeserializer()
            operationName = "GetAdmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the APNs channel for an application.
     */
    override suspend fun getApnsChannel(input: GetApnsChannelRequest): GetApnsChannelResponse {
        val op = SdkHttpOperation.build<GetApnsChannelRequest, GetApnsChannelResponse> {
            serializer = GetApnsChannelOperationSerializer()
            deserializer = GetApnsChannelOperationDeserializer()
            operationName = "GetApnsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     */
    override suspend fun getApnsSandboxChannel(input: GetApnsSandboxChannelRequest): GetApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse> {
            serializer = GetApnsSandboxChannelOperationSerializer()
            deserializer = GetApnsSandboxChannelOperationDeserializer()
            operationName = "GetApnsSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     */
    override suspend fun getApnsVoipChannel(input: GetApnsVoipChannelRequest): GetApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse> {
            serializer = GetApnsVoipChannelOperationSerializer()
            deserializer = GetApnsVoipChannelOperationDeserializer()
            operationName = "GetApnsVoipChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     */
    override suspend fun getApnsVoipSandboxChannel(input: GetApnsVoipSandboxChannelRequest): GetApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse> {
            serializer = GetApnsVoipSandboxChannelOperationSerializer()
            deserializer = GetApnsVoipSandboxChannelOperationDeserializer()
            operationName = "GetApnsVoipSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an application.
     */
    override suspend fun getApp(input: GetAppRequest): GetAppResponse {
        val op = SdkHttpOperation.build<GetAppRequest, GetAppResponse> {
            serializer = GetAppOperationSerializer()
            deserializer = GetAppOperationDeserializer()
            operationName = "GetApp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     */
    override suspend fun getApplicationDateRangeKpi(input: GetApplicationDateRangeKpiRequest): GetApplicationDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse> {
            serializer = GetApplicationDateRangeKpiOperationSerializer()
            deserializer = GetApplicationDateRangeKpiOperationDeserializer()
            operationName = "GetApplicationDateRangeKpi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the settings for an application.
     */
    override suspend fun getApplicationSettings(input: GetApplicationSettingsRequest): GetApplicationSettingsResponse {
        val op = SdkHttpOperation.build<GetApplicationSettingsRequest, GetApplicationSettingsResponse> {
            serializer = GetApplicationSettingsOperationSerializer()
            deserializer = GetApplicationSettingsOperationDeserializer()
            operationName = "GetApplicationSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     */
    override suspend fun getApps(input: GetAppsRequest): GetAppsResponse {
        val op = SdkHttpOperation.build<GetAppsRequest, GetAppsResponse> {
            serializer = GetAppsOperationSerializer()
            deserializer = GetAppsOperationDeserializer()
            operationName = "GetApps"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the Baidu channel for an application.
     */
    override suspend fun getBaiduChannel(input: GetBaiduChannelRequest): GetBaiduChannelResponse {
        val op = SdkHttpOperation.build<GetBaiduChannelRequest, GetBaiduChannelResponse> {
            serializer = GetBaiduChannelOperationSerializer()
            deserializer = GetBaiduChannelOperationDeserializer()
            operationName = "GetBaiduChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a campaign.
     */
    override suspend fun getCampaign(input: GetCampaignRequest): GetCampaignResponse {
        val op = SdkHttpOperation.build<GetCampaignRequest, GetCampaignResponse> {
            serializer = GetCampaignOperationSerializer()
            deserializer = GetCampaignOperationDeserializer()
            operationName = "GetCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the activities for a campaign.
     */
    override suspend fun getCampaignActivities(input: GetCampaignActivitiesRequest): GetCampaignActivitiesResponse {
        val op = SdkHttpOperation.build<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse> {
            serializer = GetCampaignActivitiesOperationSerializer()
            deserializer = GetCampaignActivitiesOperationDeserializer()
            operationName = "GetCampaignActivities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     */
    override suspend fun getCampaignDateRangeKpi(input: GetCampaignDateRangeKpiRequest): GetCampaignDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse> {
            serializer = GetCampaignDateRangeKpiOperationSerializer()
            deserializer = GetCampaignDateRangeKpiOperationDeserializer()
            operationName = "GetCampaignDateRangeKpi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     */
    override suspend fun getCampaignVersion(input: GetCampaignVersionRequest): GetCampaignVersionResponse {
        val op = SdkHttpOperation.build<GetCampaignVersionRequest, GetCampaignVersionResponse> {
            serializer = GetCampaignVersionOperationSerializer()
            deserializer = GetCampaignVersionOperationDeserializer()
            operationName = "GetCampaignVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     */
    override suspend fun getCampaignVersions(input: GetCampaignVersionsRequest): GetCampaignVersionsResponse {
        val op = SdkHttpOperation.build<GetCampaignVersionsRequest, GetCampaignVersionsResponse> {
            serializer = GetCampaignVersionsOperationSerializer()
            deserializer = GetCampaignVersionsOperationDeserializer()
            operationName = "GetCampaignVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.
     */
    override suspend fun getCampaigns(input: GetCampaignsRequest): GetCampaignsResponse {
        val op = SdkHttpOperation.build<GetCampaignsRequest, GetCampaignsResponse> {
            serializer = GetCampaignsOperationSerializer()
            deserializer = GetCampaignsOperationDeserializer()
            operationName = "GetCampaigns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the history and status of each channel for an application.
     */
    override suspend fun getChannels(input: GetChannelsRequest): GetChannelsResponse {
        val op = SdkHttpOperation.build<GetChannelsRequest, GetChannelsResponse> {
            serializer = GetChannelsOperationSerializer()
            deserializer = GetChannelsOperationDeserializer()
            operationName = "GetChannels"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the email channel for an application.
     */
    override suspend fun getEmailChannel(input: GetEmailChannelRequest): GetEmailChannelResponse {
        val op = SdkHttpOperation.build<GetEmailChannelRequest, GetEmailChannelResponse> {
            serializer = GetEmailChannelOperationSerializer()
            deserializer = GetEmailChannelOperationDeserializer()
            operationName = "GetEmailChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     */
    override suspend fun getEmailTemplate(input: GetEmailTemplateRequest): GetEmailTemplateResponse {
        val op = SdkHttpOperation.build<GetEmailTemplateRequest, GetEmailTemplateResponse> {
            serializer = GetEmailTemplateOperationSerializer()
            deserializer = GetEmailTemplateOperationDeserializer()
            operationName = "GetEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     */
    override suspend fun getEndpoint(input: GetEndpointRequest): GetEndpointResponse {
        val op = SdkHttpOperation.build<GetEndpointRequest, GetEndpointResponse> {
            serializer = GetEndpointOperationSerializer()
            deserializer = GetEndpointOperationDeserializer()
            operationName = "GetEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the event stream settings for an application.
     */
    override suspend fun getEventStream(input: GetEventStreamRequest): GetEventStreamResponse {
        val op = SdkHttpOperation.build<GetEventStreamRequest, GetEventStreamResponse> {
            serializer = GetEventStreamOperationSerializer()
            deserializer = GetEventStreamOperationDeserializer()
            operationName = "GetEventStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of a specific export job for an application.
     */
    override suspend fun getExportJob(input: GetExportJobRequest): GetExportJobResponse {
        val op = SdkHttpOperation.build<GetExportJobRequest, GetExportJobResponse> {
            serializer = GetExportJobOperationSerializer()
            deserializer = GetExportJobOperationDeserializer()
            operationName = "GetExportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of all the export jobs for an application.
     */
    override suspend fun getExportJobs(input: GetExportJobsRequest): GetExportJobsResponse {
        val op = SdkHttpOperation.build<GetExportJobsRequest, GetExportJobsResponse> {
            serializer = GetExportJobsOperationSerializer()
            deserializer = GetExportJobsOperationDeserializer()
            operationName = "GetExportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the GCM channel for an application.
     */
    override suspend fun getGcmChannel(input: GetGcmChannelRequest): GetGcmChannelResponse {
        val op = SdkHttpOperation.build<GetGcmChannelRequest, GetGcmChannelResponse> {
            serializer = GetGcmChannelOperationSerializer()
            deserializer = GetGcmChannelOperationDeserializer()
            operationName = "GetGcmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of a specific import job for an application.
     */
    override suspend fun getImportJob(input: GetImportJobRequest): GetImportJobResponse {
        val op = SdkHttpOperation.build<GetImportJobRequest, GetImportJobResponse> {
            serializer = GetImportJobOperationSerializer()
            deserializer = GetImportJobOperationDeserializer()
            operationName = "GetImportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of all the import jobs for an application.
     */
    override suspend fun getImportJobs(input: GetImportJobsRequest): GetImportJobsResponse {
        val op = SdkHttpOperation.build<GetImportJobsRequest, GetImportJobsResponse> {
            serializer = GetImportJobsOperationSerializer()
            deserializer = GetImportJobsOperationDeserializer()
            operationName = "GetImportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the in-app messages targeted for the provided endpoint ID.
     */
    override suspend fun getInAppMessages(input: GetInAppMessagesRequest): GetInAppMessagesResponse {
        val op = SdkHttpOperation.build<GetInAppMessagesRequest, GetInAppMessagesResponse> {
            serializer = GetInAppMessagesOperationSerializer()
            deserializer = GetInAppMessagesOperationDeserializer()
            operationName = "GetInAppMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the content and settings of a message template for messages sent through the in-app channel.
     */
    override suspend fun getInAppTemplate(input: GetInAppTemplateRequest): GetInAppTemplateResponse {
        val op = SdkHttpOperation.build<GetInAppTemplateRequest, GetInAppTemplateResponse> {
            serializer = GetInAppTemplateOperationSerializer()
            deserializer = GetInAppTemplateOperationDeserializer()
            operationName = "GetInAppTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a journey.
     */
    override suspend fun getJourney(input: GetJourneyRequest): GetJourneyResponse {
        val op = SdkHttpOperation.build<GetJourneyRequest, GetJourneyResponse> {
            serializer = GetJourneyOperationSerializer()
            deserializer = GetJourneyOperationDeserializer()
            operationName = "GetJourney"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     */
    override suspend fun getJourneyDateRangeKpi(input: GetJourneyDateRangeKpiRequest): GetJourneyDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetJourneyDateRangeKpiRequest, GetJourneyDateRangeKpiResponse> {
            serializer = GetJourneyDateRangeKpiOperationSerializer()
            deserializer = GetJourneyDateRangeKpiOperationDeserializer()
            operationName = "GetJourneyDateRangeKpi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     */
    override suspend fun getJourneyExecutionActivityMetrics(input: GetJourneyExecutionActivityMetricsRequest): GetJourneyExecutionActivityMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyExecutionActivityMetricsRequest, GetJourneyExecutionActivityMetricsResponse> {
            serializer = GetJourneyExecutionActivityMetricsOperationSerializer()
            deserializer = GetJourneyExecutionActivityMetricsOperationDeserializer()
            operationName = "GetJourneyExecutionActivityMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     */
    override suspend fun getJourneyExecutionMetrics(input: GetJourneyExecutionMetricsRequest): GetJourneyExecutionMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyExecutionMetricsRequest, GetJourneyExecutionMetricsResponse> {
            serializer = GetJourneyExecutionMetricsOperationSerializer()
            deserializer = GetJourneyExecutionMetricsOperationDeserializer()
            operationName = "GetJourneyExecutionMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.
     */
    override suspend fun getJourneyRunExecutionActivityMetrics(input: GetJourneyRunExecutionActivityMetricsRequest): GetJourneyRunExecutionActivityMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyRunExecutionActivityMetricsRequest, GetJourneyRunExecutionActivityMetricsResponse> {
            serializer = GetJourneyRunExecutionActivityMetricsOperationSerializer()
            deserializer = GetJourneyRunExecutionActivityMetricsOperationDeserializer()
            operationName = "GetJourneyRunExecutionActivityMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.
     */
    override suspend fun getJourneyRunExecutionMetrics(input: GetJourneyRunExecutionMetricsRequest): GetJourneyRunExecutionMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyRunExecutionMetricsRequest, GetJourneyRunExecutionMetricsResponse> {
            serializer = GetJourneyRunExecutionMetricsOperationSerializer()
            deserializer = GetJourneyRunExecutionMetricsOperationDeserializer()
            operationName = "GetJourneyRunExecutionMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the runs of a journey.
     */
    override suspend fun getJourneyRuns(input: GetJourneyRunsRequest): GetJourneyRunsResponse {
        val op = SdkHttpOperation.build<GetJourneyRunsRequest, GetJourneyRunsResponse> {
            serializer = GetJourneyRunsOperationSerializer()
            deserializer = GetJourneyRunsOperationDeserializer()
            operationName = "GetJourneyRuns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through a push notification channel.
     */
    override suspend fun getPushTemplate(input: GetPushTemplateRequest): GetPushTemplateResponse {
        val op = SdkHttpOperation.build<GetPushTemplateRequest, GetPushTemplateResponse> {
            serializer = GetPushTemplateOperationSerializer()
            deserializer = GetPushTemplateOperationDeserializer()
            operationName = "GetPushTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun getRecommenderConfiguration(input: GetRecommenderConfigurationRequest): GetRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<GetRecommenderConfigurationRequest, GetRecommenderConfigurationResponse> {
            serializer = GetRecommenderConfigurationOperationSerializer()
            deserializer = GetRecommenderConfigurationOperationDeserializer()
            operationName = "GetRecommenderConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.
     */
    override suspend fun getRecommenderConfigurations(input: GetRecommenderConfigurationsRequest): GetRecommenderConfigurationsResponse {
        val op = SdkHttpOperation.build<GetRecommenderConfigurationsRequest, GetRecommenderConfigurationsResponse> {
            serializer = GetRecommenderConfigurationsOperationSerializer()
            deserializer = GetRecommenderConfigurationsOperationDeserializer()
            operationName = "GetRecommenderConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.
     */
    override suspend fun getSegment(input: GetSegmentRequest): GetSegmentResponse {
        val op = SdkHttpOperation.build<GetSegmentRequest, GetSegmentResponse> {
            serializer = GetSegmentOperationSerializer()
            deserializer = GetSegmentOperationDeserializer()
            operationName = "GetSegment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the export jobs for a segment.
     */
    override suspend fun getSegmentExportJobs(input: GetSegmentExportJobsRequest): GetSegmentExportJobsResponse {
        val op = SdkHttpOperation.build<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse> {
            serializer = GetSegmentExportJobsOperationSerializer()
            deserializer = GetSegmentExportJobsOperationDeserializer()
            operationName = "GetSegmentExportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the import jobs for a segment.
     */
    override suspend fun getSegmentImportJobs(input: GetSegmentImportJobsRequest): GetSegmentImportJobsResponse {
        val op = SdkHttpOperation.build<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse> {
            serializer = GetSegmentImportJobsOperationSerializer()
            deserializer = GetSegmentImportJobsOperationDeserializer()
            operationName = "GetSegmentImportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.
     */
    override suspend fun getSegmentVersion(input: GetSegmentVersionRequest): GetSegmentVersionResponse {
        val op = SdkHttpOperation.build<GetSegmentVersionRequest, GetSegmentVersionResponse> {
            serializer = GetSegmentVersionOperationSerializer()
            deserializer = GetSegmentVersionOperationDeserializer()
            operationName = "GetSegmentVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.
     */
    override suspend fun getSegmentVersions(input: GetSegmentVersionsRequest): GetSegmentVersionsResponse {
        val op = SdkHttpOperation.build<GetSegmentVersionsRequest, GetSegmentVersionsResponse> {
            serializer = GetSegmentVersionsOperationSerializer()
            deserializer = GetSegmentVersionsOperationDeserializer()
            operationName = "GetSegmentVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.
     */
    override suspend fun getSegments(input: GetSegmentsRequest): GetSegmentsResponse {
        val op = SdkHttpOperation.build<GetSegmentsRequest, GetSegmentsResponse> {
            serializer = GetSegmentsOperationSerializer()
            deserializer = GetSegmentsOperationDeserializer()
            operationName = "GetSegments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the SMS channel for an application.
     */
    override suspend fun getSmsChannel(input: GetSmsChannelRequest): GetSmsChannelResponse {
        val op = SdkHttpOperation.build<GetSmsChannelRequest, GetSmsChannelResponse> {
            serializer = GetSmsChannelOperationSerializer()
            deserializer = GetSmsChannelOperationDeserializer()
            operationName = "GetSmsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     */
    override suspend fun getSmsTemplate(input: GetSmsTemplateRequest): GetSmsTemplateResponse {
        val op = SdkHttpOperation.build<GetSmsTemplateRequest, GetSmsTemplateResponse> {
            serializer = GetSmsTemplateOperationSerializer()
            deserializer = GetSmsTemplateOperationDeserializer()
            operationName = "GetSmsTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     */
    override suspend fun getUserEndpoints(input: GetUserEndpointsRequest): GetUserEndpointsResponse {
        val op = SdkHttpOperation.build<GetUserEndpointsRequest, GetUserEndpointsResponse> {
            serializer = GetUserEndpointsOperationSerializer()
            deserializer = GetUserEndpointsOperationDeserializer()
            operationName = "GetUserEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status and settings of the voice channel for an application.
     */
    override suspend fun getVoiceChannel(input: GetVoiceChannelRequest): GetVoiceChannelResponse {
        val op = SdkHttpOperation.build<GetVoiceChannelRequest, GetVoiceChannelResponse> {
            serializer = GetVoiceChannelOperationSerializer()
            deserializer = GetVoiceChannelOperationDeserializer()
            operationName = "GetVoiceChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     */
    override suspend fun getVoiceTemplate(input: GetVoiceTemplateRequest): GetVoiceTemplateResponse {
        val op = SdkHttpOperation.build<GetVoiceTemplateRequest, GetVoiceTemplateResponse> {
            serializer = GetVoiceTemplateOperationSerializer()
            deserializer = GetVoiceTemplateOperationDeserializer()
            operationName = "GetVoiceTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.
     */
    override suspend fun listJourneys(input: ListJourneysRequest): ListJourneysResponse {
        val op = SdkHttpOperation.build<ListJourneysRequest, ListJourneysResponse> {
            serializer = ListJourneysOperationSerializer()
            deserializer = ListJourneysOperationDeserializer()
            operationName = "ListJourneys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the versions of a specific message template.
     */
    override suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListTemplateVersionsRequest, ListTemplateVersionsResponse> {
            serializer = ListTemplateVersionsOperationSerializer()
            deserializer = ListTemplateVersionsOperationDeserializer()
            operationName = "ListTemplateVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            operationName = "ListTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a phone number.
     */
    override suspend fun phoneNumberValidate(input: PhoneNumberValidateRequest): PhoneNumberValidateResponse {
        val op = SdkHttpOperation.build<PhoneNumberValidateRequest, PhoneNumberValidateResponse> {
            serializer = PhoneNumberValidateOperationSerializer()
            deserializer = PhoneNumberValidateOperationDeserializer()
            operationName = "PhoneNumberValidate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new event stream for an application or updates the settings of an existing event stream for an application.
     */
    override suspend fun putEventStream(input: PutEventStreamRequest): PutEventStreamResponse {
        val op = SdkHttpOperation.build<PutEventStreamRequest, PutEventStreamResponse> {
            serializer = PutEventStreamOperationSerializer()
            deserializer = PutEventStreamOperationDeserializer()
            operationName = "PutEventStream"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.
     */
    override suspend fun putEvents(input: PutEventsRequest): PutEventsResponse {
        val op = SdkHttpOperation.build<PutEventsRequest, PutEventsResponse> {
            serializer = PutEventsOperationSerializer()
            deserializer = PutEventsOperationDeserializer()
            operationName = "PutEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.
     */
    override suspend fun removeAttributes(input: RemoveAttributesRequest): RemoveAttributesResponse {
        val op = SdkHttpOperation.build<RemoveAttributesRequest, RemoveAttributesResponse> {
            serializer = RemoveAttributesOperationSerializer()
            deserializer = RemoveAttributesOperationDeserializer()
            operationName = "RemoveAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates and sends a direct message.
     */
    override suspend fun sendMessages(input: SendMessagesRequest): SendMessagesResponse {
        val op = SdkHttpOperation.build<SendMessagesRequest, SendMessagesResponse> {
            serializer = SendMessagesOperationSerializer()
            deserializer = SendMessagesOperationDeserializer()
            operationName = "SendMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Send an OTP message
     */
    override suspend fun sendOtpMessage(input: SendOtpMessageRequest): SendOtpMessageResponse {
        val op = SdkHttpOperation.build<SendOtpMessageRequest, SendOtpMessageResponse> {
            serializer = SendOTPMessageOperationSerializer()
            deserializer = SendOTPMessageOperationDeserializer()
            operationName = "SendOTPMessage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates and sends a message to a list of users.
     */
    override suspend fun sendUsersMessages(input: SendUsersMessagesRequest): SendUsersMessagesResponse {
        val op = SdkHttpOperation.build<SendUsersMessagesRequest, SendUsersMessagesResponse> {
            serializer = SendUsersMessagesOperationSerializer()
            deserializer = SendUsersMessagesOperationDeserializer()
            operationName = "SendUsersMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.
     */
    override suspend fun updateAdmChannel(input: UpdateAdmChannelRequest): UpdateAdmChannelResponse {
        val op = SdkHttpOperation.build<UpdateAdmChannelRequest, UpdateAdmChannelResponse> {
            serializer = UpdateAdmChannelOperationSerializer()
            deserializer = UpdateAdmChannelOperationDeserializer()
            operationName = "UpdateAdmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.
     */
    override suspend fun updateApnsChannel(input: UpdateApnsChannelRequest): UpdateApnsChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsChannelRequest, UpdateApnsChannelResponse> {
            serializer = UpdateApnsChannelOperationSerializer()
            deserializer = UpdateApnsChannelOperationDeserializer()
            operationName = "UpdateApnsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.
     */
    override suspend fun updateApnsSandboxChannel(input: UpdateApnsSandboxChannelRequest): UpdateApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse> {
            serializer = UpdateApnsSandboxChannelOperationSerializer()
            deserializer = UpdateApnsSandboxChannelOperationDeserializer()
            operationName = "UpdateApnsSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.
     */
    override suspend fun updateApnsVoipChannel(input: UpdateApnsVoipChannelRequest): UpdateApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse> {
            serializer = UpdateApnsVoipChannelOperationSerializer()
            deserializer = UpdateApnsVoipChannelOperationDeserializer()
            operationName = "UpdateApnsVoipChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.
     */
    override suspend fun updateApnsVoipSandboxChannel(input: UpdateApnsVoipSandboxChannelRequest): UpdateApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse> {
            serializer = UpdateApnsVoipSandboxChannelOperationSerializer()
            deserializer = UpdateApnsVoipSandboxChannelOperationDeserializer()
            operationName = "UpdateApnsVoipSandboxChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for an application.
     */
    override suspend fun updateApplicationSettings(input: UpdateApplicationSettingsRequest): UpdateApplicationSettingsResponse {
        val op = SdkHttpOperation.build<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse> {
            serializer = UpdateApplicationSettingsOperationSerializer()
            deserializer = UpdateApplicationSettingsOperationDeserializer()
            operationName = "UpdateApplicationSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.
     */
    override suspend fun updateBaiduChannel(input: UpdateBaiduChannelRequest): UpdateBaiduChannelResponse {
        val op = SdkHttpOperation.build<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse> {
            serializer = UpdateBaiduChannelOperationSerializer()
            deserializer = UpdateBaiduChannelOperationDeserializer()
            operationName = "UpdateBaiduChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration and other settings for a campaign.
     */
    override suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse {
        val op = SdkHttpOperation.build<UpdateCampaignRequest, UpdateCampaignResponse> {
            serializer = UpdateCampaignOperationSerializer()
            deserializer = UpdateCampaignOperationDeserializer()
            operationName = "UpdateCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the email channel for an application or updates the status and settings of the email channel for an application.
     */
    override suspend fun updateEmailChannel(input: UpdateEmailChannelRequest): UpdateEmailChannelResponse {
        val op = SdkHttpOperation.build<UpdateEmailChannelRequest, UpdateEmailChannelResponse> {
            serializer = UpdateEmailChannelOperationSerializer()
            deserializer = UpdateEmailChannelOperationDeserializer()
            operationName = "UpdateEmailChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing message template for messages that are sent through the email channel.
     */
    override suspend fun updateEmailTemplate(input: UpdateEmailTemplateRequest): UpdateEmailTemplateResponse {
        val op = SdkHttpOperation.build<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse> {
            serializer = UpdateEmailTemplateOperationSerializer()
            deserializer = UpdateEmailTemplateOperationDeserializer()
            operationName = "UpdateEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    override suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse {
        val op = SdkHttpOperation.build<UpdateEndpointRequest, UpdateEndpointResponse> {
            serializer = UpdateEndpointOperationSerializer()
            deserializer = UpdateEndpointOperationDeserializer()
            operationName = "UpdateEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    override suspend fun updateEndpointsBatch(input: UpdateEndpointsBatchRequest): UpdateEndpointsBatchResponse {
        val op = SdkHttpOperation.build<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse> {
            serializer = UpdateEndpointsBatchOperationSerializer()
            deserializer = UpdateEndpointsBatchOperationDeserializer()
            operationName = "UpdateEndpointsBatch"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.
     */
    override suspend fun updateGcmChannel(input: UpdateGcmChannelRequest): UpdateGcmChannelResponse {
        val op = SdkHttpOperation.build<UpdateGcmChannelRequest, UpdateGcmChannelResponse> {
            serializer = UpdateGcmChannelOperationSerializer()
            deserializer = UpdateGcmChannelOperationDeserializer()
            operationName = "UpdateGcmChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing message template for messages sent through the in-app message channel.
     */
    override suspend fun updateInAppTemplate(input: UpdateInAppTemplateRequest): UpdateInAppTemplateResponse {
        val op = SdkHttpOperation.build<UpdateInAppTemplateRequest, UpdateInAppTemplateResponse> {
            serializer = UpdateInAppTemplateOperationSerializer()
            deserializer = UpdateInAppTemplateOperationDeserializer()
            operationName = "UpdateInAppTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration and other settings for a journey.
     */
    override suspend fun updateJourney(input: UpdateJourneyRequest): UpdateJourneyResponse {
        val op = SdkHttpOperation.build<UpdateJourneyRequest, UpdateJourneyResponse> {
            serializer = UpdateJourneyOperationSerializer()
            deserializer = UpdateJourneyOperationDeserializer()
            operationName = "UpdateJourney"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels (stops) an active journey.
     */
    override suspend fun updateJourneyState(input: UpdateJourneyStateRequest): UpdateJourneyStateResponse {
        val op = SdkHttpOperation.build<UpdateJourneyStateRequest, UpdateJourneyStateResponse> {
            serializer = UpdateJourneyStateOperationSerializer()
            deserializer = UpdateJourneyStateOperationDeserializer()
            operationName = "UpdateJourneyState"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing message template for messages that are sent through a push notification channel.
     */
    override suspend fun updatePushTemplate(input: UpdatePushTemplateRequest): UpdatePushTemplateResponse {
        val op = SdkHttpOperation.build<UpdatePushTemplateRequest, UpdatePushTemplateResponse> {
            serializer = UpdatePushTemplateOperationSerializer()
            deserializer = UpdatePushTemplateOperationDeserializer()
            operationName = "UpdatePushTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun updateRecommenderConfiguration(input: UpdateRecommenderConfigurationRequest): UpdateRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateRecommenderConfigurationRequest, UpdateRecommenderConfigurationResponse> {
            serializer = UpdateRecommenderConfigurationOperationSerializer()
            deserializer = UpdateRecommenderConfigurationOperationDeserializer()
            operationName = "UpdateRecommenderConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    override suspend fun updateSegment(input: UpdateSegmentRequest): UpdateSegmentResponse {
        val op = SdkHttpOperation.build<UpdateSegmentRequest, UpdateSegmentResponse> {
            serializer = UpdateSegmentOperationSerializer()
            deserializer = UpdateSegmentOperationDeserializer()
            operationName = "UpdateSegment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.
     */
    override suspend fun updateSmsChannel(input: UpdateSmsChannelRequest): UpdateSmsChannelResponse {
        val op = SdkHttpOperation.build<UpdateSmsChannelRequest, UpdateSmsChannelResponse> {
            serializer = UpdateSmsChannelOperationSerializer()
            deserializer = UpdateSmsChannelOperationDeserializer()
            operationName = "UpdateSmsChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing message template for messages that are sent through the SMS channel.
     */
    override suspend fun updateSmsTemplate(input: UpdateSmsTemplateRequest): UpdateSmsTemplateResponse {
        val op = SdkHttpOperation.build<UpdateSmsTemplateRequest, UpdateSmsTemplateResponse> {
            serializer = UpdateSmsTemplateOperationSerializer()
            deserializer = UpdateSmsTemplateOperationDeserializer()
            operationName = "UpdateSmsTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the status of a specific version of a message template to *active*.
     */
    override suspend fun updateTemplateActiveVersion(input: UpdateTemplateActiveVersionRequest): UpdateTemplateActiveVersionResponse {
        val op = SdkHttpOperation.build<UpdateTemplateActiveVersionRequest, UpdateTemplateActiveVersionResponse> {
            serializer = UpdateTemplateActiveVersionOperationSerializer()
            deserializer = UpdateTemplateActiveVersionOperationDeserializer()
            operationName = "UpdateTemplateActiveVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an application.
     */
    override suspend fun updateVoiceChannel(input: UpdateVoiceChannelRequest): UpdateVoiceChannelResponse {
        val op = SdkHttpOperation.build<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse> {
            serializer = UpdateVoiceChannelOperationSerializer()
            deserializer = UpdateVoiceChannelOperationDeserializer()
            operationName = "UpdateVoiceChannel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing message template for messages that are sent through the voice channel.
     */
    override suspend fun updateVoiceTemplate(input: UpdateVoiceTemplateRequest): UpdateVoiceTemplateResponse {
        val op = SdkHttpOperation.build<UpdateVoiceTemplateRequest, UpdateVoiceTemplateResponse> {
            serializer = UpdateVoiceTemplateOperationSerializer()
            deserializer = UpdateVoiceTemplateOperationDeserializer()
            operationName = "UpdateVoiceTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Verify an OTP
     */
    override suspend fun verifyOtpMessage(input: VerifyOtpMessageRequest): VerifyOtpMessageResponse {
        val op = SdkHttpOperation.build<VerifyOtpMessageRequest, VerifyOtpMessageResponse> {
            serializer = VerifyOTPMessageOperationSerializer()
            deserializer = VerifyOTPMessageOperationDeserializer()
            operationName = "VerifyOTPMessage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mobiletargeting")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
