// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdatePushTemplateOperationSerializer: HttpSerialize<UpdatePushTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdatePushTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "templates",
                "${input.templateName}".encodeLabel(),
                "push",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.createNewVersion != null) append("create-new-version", "${input.createNewVersion}")
                if (input.version != null) append("version", input.version)
            }
        }

        if (input.pushNotificationTemplateRequest != null) {
            val payload = serializePushNotificationTemplateRequestPayload(input.pushNotificationTemplateRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.pushNotificationTemplateRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
