// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.GcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateGcmChannelRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateGcmChannelOperationSerializer: HttpSerialize<UpdateGcmChannelRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateGcmChannelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apps",
                "${input.applicationId}".encodeLabel(),
                "channels",
                "gcm",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.gcmChannelRequest != null) {
            val payload = serializeGcmChannelRequestPayload(input.gcmChannelRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.gcmChannelRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
