// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.RemoveAttributesRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateAttributesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RemoveAttributesOperationSerializer: HttpSerialize<RemoveAttributesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RemoveAttributesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apps",
                "${input.applicationId}".encodeLabel(),
                "attributes",
                "${input.attributeType}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.updateAttributesRequest != null) {
            val payload = serializeUpdateAttributesRequestPayload(input.updateAttributesRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.updateAttributesRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
