// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.CreateExportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.ExportJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateExportJobOperationSerializer: HttpSerialize<CreateExportJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateExportJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apps",
                "${input.applicationId}".encodeLabel(),
                "jobs",
                "export",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.exportJobRequest != null) {
            val payload = serializeExportJobRequestPayload(input.exportJobRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.exportJobRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
