// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a campaign treatment. A *treatment* is a variation of a campaign that's used for A/B testing of a campaign.
 */
public class TreatmentResource private constructor(builder: Builder) {
    /**
     * The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
     */
    public val customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = builder.customDeliveryConfiguration
    /**
     * The unique identifier for the treatment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The message configuration settings for the treatment.
     */
    public val messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = builder.messageConfiguration
    /**
     * The schedule settings for the treatment.
     */
    public val schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = builder.schedule
    /**
     * The allocated percentage of users (segment members) that the treatment is sent to.
     */
    public val sizePercent: kotlin.Int? = builder.sizePercent
    /**
     * The current status of the treatment.
     */
    public val state: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = builder.state
    /**
     * The message template to use for the treatment.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * The custom description of the treatment.
     */
    public val treatmentDescription: kotlin.String? = builder.treatmentDescription
    /**
     * The custom name of the treatment.
     */
    public val treatmentName: kotlin.String? = builder.treatmentName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.TreatmentResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TreatmentResource(")
        append("customDeliveryConfiguration=$customDeliveryConfiguration,")
        append("id=$id,")
        append("messageConfiguration=$messageConfiguration,")
        append("schedule=$schedule,")
        append("sizePercent=$sizePercent,")
        append("state=$state,")
        append("templateConfiguration=$templateConfiguration,")
        append("treatmentDescription=$treatmentDescription,")
        append("treatmentName=$treatmentName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDeliveryConfiguration?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (messageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sizePercent ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (treatmentDescription?.hashCode() ?: 0)
        result = 31 * result + (treatmentName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TreatmentResource

        if (customDeliveryConfiguration != other.customDeliveryConfiguration) return false
        if (id != other.id) return false
        if (messageConfiguration != other.messageConfiguration) return false
        if (schedule != other.schedule) return false
        if (sizePercent != other.sizePercent) return false
        if (state != other.state) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (treatmentDescription != other.treatmentDescription) return false
        if (treatmentName != other.treatmentName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.TreatmentResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
         */
        public var customDeliveryConfiguration: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration? = null
        /**
         * The unique identifier for the treatment.
         */
        public var id: kotlin.String? = null
        /**
         * The message configuration settings for the treatment.
         */
        public var messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration? = null
        /**
         * The schedule settings for the treatment.
         */
        public var schedule: aws.sdk.kotlin.services.pinpoint.model.Schedule? = null
        /**
         * The allocated percentage of users (segment members) that the treatment is sent to.
         */
        public var sizePercent: kotlin.Int? = null
        /**
         * The current status of the treatment.
         */
        public var state: aws.sdk.kotlin.services.pinpoint.model.CampaignState? = null
        /**
         * The message template to use for the treatment.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = null
        /**
         * The custom description of the treatment.
         */
        public var treatmentDescription: kotlin.String? = null
        /**
         * The custom name of the treatment.
         */
        public var treatmentName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.TreatmentResource) : this() {
            this.customDeliveryConfiguration = x.customDeliveryConfiguration
            this.id = x.id
            this.messageConfiguration = x.messageConfiguration
            this.schedule = x.schedule
            this.sizePercent = x.sizePercent
            this.state = x.state
            this.templateConfiguration = x.templateConfiguration
            this.treatmentDescription = x.treatmentDescription
            this.treatmentName = x.treatmentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.TreatmentResource = TreatmentResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration] inside the given [block]
         */
        public fun customDeliveryConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.customDeliveryConfiguration = aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration] inside the given [block]
         */
        public fun messageConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.Builder.() -> kotlin.Unit) {
            this.messageConfiguration = aws.sdk.kotlin.services.pinpoint.model.MessageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.pinpoint.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.pinpoint.model.Schedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.pinpoint.model.CampaignState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.pinpoint.model.CampaignState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.invoke(block)
        }
    }
}
