// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.
 */
public class SmsTemplateRequest private constructor(builder: Builder) {
    /**
     * The message body to use in text messages that are based on the message template.
     */
    public val body: kotlin.String? = builder.body
    /**
     * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
     */
    public val recommenderId: kotlin.String? = builder.recommenderId
    /**
     * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
     *
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A custom description of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsTemplateRequest(")
        append("body=$body,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("recommenderId=$recommenderId,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (recommenderId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsTemplateRequest

        if (body != other.body) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (recommenderId != other.recommenderId) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The message body to use in text messages that are based on the message template.
         */
        public var body: kotlin.String? = null
        /**
         * A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
         */
        public var recommenderId: kotlin.String? = null
        /**
         * As of **22-05-2023** tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either [Tags](https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html) in the *API Reference for Amazon Pinpoint*, [resourcegroupstaggingapi](https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html) commands in the *AWS Command Line Interface Documentation* or [resourcegroupstaggingapi](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html) in the *AWS SDK*.
         *
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * A custom description of the message template.
         */
        public var templateDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SmsTemplateRequest) : this() {
            this.body = x.body
            this.defaultSubstitutions = x.defaultSubstitutions
            this.recommenderId = x.recommenderId
            this.tags = x.tags
            this.templateDescription = x.templateDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SmsTemplateRequest = SmsTemplateRequest(this)
    }
}
