// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the content and settings for a message template that can be used in messages that are sent through a push notification channel.
 */
public class PushNotificationTemplateResponse private constructor(builder: Builder) {
    /**
     * The message template that's used for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val adm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.adm
    /**
     * The message template that's used for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val apns: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate? = builder.apns
    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val baidu: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.baidu
    /**
     * The date, in ISO 8601 format, when the message template was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The default message template that's used for push notification channels.
     */
    public val default: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate? = builder.default
    /**
     * The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The message template that's used for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public val gcm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = builder.gcm
    /**
     * The date, in ISO 8601 format, when the message template was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The unique identifier for the recommender model that's used by the message template.
     */
    public val recommenderId: kotlin.String? = builder.recommenderId
    /**
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The custom description of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription
    /**
     * The name of the message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type of channel that the message template is designed for. For a push notification template, this value is PUSH.
     */
    public val templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = builder.templateType
    /**
     * The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PushNotificationTemplateResponse(")
        append("adm=$adm,")
        append("apns=$apns,")
        append("arn=$arn,")
        append("baidu=$baidu,")
        append("creationDate=$creationDate,")
        append("default=$default,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("gcm=$gcm,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("recommenderId=$recommenderId,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription,")
        append("templateName=$templateName,")
        append("templateType=$templateType,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adm?.hashCode() ?: 0
        result = 31 * result + (apns?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (baidu?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (default?.hashCode() ?: 0)
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (gcm?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (recommenderId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateType?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PushNotificationTemplateResponse

        if (adm != other.adm) return false
        if (apns != other.apns) return false
        if (arn != other.arn) return false
        if (baidu != other.baidu) return false
        if (creationDate != other.creationDate) return false
        if (default != other.default) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (gcm != other.gcm) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (recommenderId != other.recommenderId) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false
        if (templateName != other.templateName) return false
        if (templateType != other.templateType) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The message template that's used for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var adm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The message template that's used for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var apns: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate? = null
        /**
         * The Amazon Resource Name (ARN) of the message template.
         */
        public var arn: kotlin.String? = null
        /**
         * The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var baidu: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The date, in ISO 8601 format, when the message template was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The default message template that's used for push notification channels.
         */
        public var default: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate? = null
        /**
         * The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The message template that's used for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         */
        public var gcm: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate? = null
        /**
         * The date, in ISO 8601 format, when the message template was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The unique identifier for the recommender model that's used by the message template.
         */
        public var recommenderId: kotlin.String? = null
        /**
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null
        /**
         * The custom description of the message template.
         */
        public var templateDescription: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type of channel that the message template is designed for. For a push notification template, this value is PUSH.
         */
        public var templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = null
        /**
         * The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateResponse) : this() {
            this.adm = x.adm
            this.apns = x.apns
            this.arn = x.arn
            this.baidu = x.baidu
            this.creationDate = x.creationDate
            this.default = x.default
            this.defaultSubstitutions = x.defaultSubstitutions
            this.gcm = x.gcm
            this.lastModifiedDate = x.lastModifiedDate
            this.recommenderId = x.recommenderId
            this.tags = x.tags
            this.templateDescription = x.templateDescription
            this.templateName = x.templateName
            this.templateType = x.templateType
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.PushNotificationTemplateResponse = PushNotificationTemplateResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun adm(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.adm = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate] inside the given [block]
         */
        public fun apns(block: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.apns = aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun baidu(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.baidu = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate] inside the given [block]
         */
        public fun default(block: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.default = aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate] inside the given [block]
         */
        public fun gcm(block: aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.Builder.() -> kotlin.Unit) {
            this.gcm = aws.sdk.kotlin.services.pinpoint.model.AndroidPushNotificationTemplate.invoke(block)
        }
    }
}
