// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about a phone number.
 */
public class NumberValidateResponse private constructor(builder: Builder) {
    /**
     * The carrier or service provider that the phone number is currently registered with. In some countries and regions, this value may be the carrier or service provider that the phone number was originally registered with.
     */
    public val carrier: kotlin.String? = builder.carrier
    /**
     * The name of the city where the phone number was originally registered.
     */
    public val city: kotlin.String? = builder.city
    /**
     * The cleansed phone number, in E.164 format, for the location where the phone number was originally registered.
     */
    public val cleansedPhoneNumberE164: kotlin.String? = builder.cleansedPhoneNumberE164
    /**
     * The cleansed phone number, in the format for the location where the phone number was originally registered.
     */
    public val cleansedPhoneNumberNational: kotlin.String? = builder.cleansedPhoneNumberNational
    /**
     * The name of the country or region where the phone number was originally registered.
     */
    public val country: kotlin.String? = builder.country
    /**
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was originally registered.
     */
    public val countryCodeIso2: kotlin.String? = builder.countryCodeIso2
    /**
     * The numeric code for the country or region where the phone number was originally registered.
     */
    public val countryCodeNumeric: kotlin.String? = builder.countryCodeNumeric
    /**
     * The name of the county where the phone number was originally registered.
     */
    public val county: kotlin.String? = builder.county
    /**
     * The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the request body.
     */
    public val originalCountryCodeIso2: kotlin.String? = builder.originalCountryCodeIso2
    /**
     * The phone number that was sent in the request body.
     */
    public val originalPhoneNumber: kotlin.String? = builder.originalPhoneNumber
    /**
     * The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP, INVALID, PREPAID, and OTHER.
     */
    public val phoneType: kotlin.String? = builder.phoneType
    /**
     * The phone type, represented by an integer. Valid values are: 0 (mobile), 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).
     */
    public val phoneTypeCode: kotlin.Int? = builder.phoneTypeCode
    /**
     * The time zone for the location where the phone number was originally registered.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * The postal or ZIP code for the location where the phone number was originally registered.
     */
    public val zipCode: kotlin.String? = builder.zipCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.NumberValidateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NumberValidateResponse(")
        append("carrier=$carrier,")
        append("city=$city,")
        append("cleansedPhoneNumberE164=$cleansedPhoneNumberE164,")
        append("cleansedPhoneNumberNational=$cleansedPhoneNumberNational,")
        append("country=$country,")
        append("countryCodeIso2=$countryCodeIso2,")
        append("countryCodeNumeric=$countryCodeNumeric,")
        append("county=$county,")
        append("originalCountryCodeIso2=$originalCountryCodeIso2,")
        append("originalPhoneNumber=$originalPhoneNumber,")
        append("phoneType=$phoneType,")
        append("phoneTypeCode=$phoneTypeCode,")
        append("timezone=$timezone,")
        append("zipCode=$zipCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = carrier?.hashCode() ?: 0
        result = 31 * result + (city?.hashCode() ?: 0)
        result = 31 * result + (cleansedPhoneNumberE164?.hashCode() ?: 0)
        result = 31 * result + (cleansedPhoneNumberNational?.hashCode() ?: 0)
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (countryCodeIso2?.hashCode() ?: 0)
        result = 31 * result + (countryCodeNumeric?.hashCode() ?: 0)
        result = 31 * result + (county?.hashCode() ?: 0)
        result = 31 * result + (originalCountryCodeIso2?.hashCode() ?: 0)
        result = 31 * result + (originalPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneType?.hashCode() ?: 0)
        result = 31 * result + (phoneTypeCode ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (zipCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NumberValidateResponse

        if (carrier != other.carrier) return false
        if (city != other.city) return false
        if (cleansedPhoneNumberE164 != other.cleansedPhoneNumberE164) return false
        if (cleansedPhoneNumberNational != other.cleansedPhoneNumberNational) return false
        if (country != other.country) return false
        if (countryCodeIso2 != other.countryCodeIso2) return false
        if (countryCodeNumeric != other.countryCodeNumeric) return false
        if (county != other.county) return false
        if (originalCountryCodeIso2 != other.originalCountryCodeIso2) return false
        if (originalPhoneNumber != other.originalPhoneNumber) return false
        if (phoneType != other.phoneType) return false
        if (phoneTypeCode != other.phoneTypeCode) return false
        if (timezone != other.timezone) return false
        if (zipCode != other.zipCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.NumberValidateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The carrier or service provider that the phone number is currently registered with. In some countries and regions, this value may be the carrier or service provider that the phone number was originally registered with.
         */
        public var carrier: kotlin.String? = null
        /**
         * The name of the city where the phone number was originally registered.
         */
        public var city: kotlin.String? = null
        /**
         * The cleansed phone number, in E.164 format, for the location where the phone number was originally registered.
         */
        public var cleansedPhoneNumberE164: kotlin.String? = null
        /**
         * The cleansed phone number, in the format for the location where the phone number was originally registered.
         */
        public var cleansedPhoneNumberNational: kotlin.String? = null
        /**
         * The name of the country or region where the phone number was originally registered.
         */
        public var country: kotlin.String? = null
        /**
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was originally registered.
         */
        public var countryCodeIso2: kotlin.String? = null
        /**
         * The numeric code for the country or region where the phone number was originally registered.
         */
        public var countryCodeNumeric: kotlin.String? = null
        /**
         * The name of the county where the phone number was originally registered.
         */
        public var county: kotlin.String? = null
        /**
         * The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the request body.
         */
        public var originalCountryCodeIso2: kotlin.String? = null
        /**
         * The phone number that was sent in the request body.
         */
        public var originalPhoneNumber: kotlin.String? = null
        /**
         * The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP, INVALID, PREPAID, and OTHER.
         */
        public var phoneType: kotlin.String? = null
        /**
         * The phone type, represented by an integer. Valid values are: 0 (mobile), 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).
         */
        public var phoneTypeCode: kotlin.Int? = null
        /**
         * The time zone for the location where the phone number was originally registered.
         */
        public var timezone: kotlin.String? = null
        /**
         * The postal or ZIP code for the location where the phone number was originally registered.
         */
        public var zipCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.NumberValidateResponse) : this() {
            this.carrier = x.carrier
            this.city = x.city
            this.cleansedPhoneNumberE164 = x.cleansedPhoneNumberE164
            this.cleansedPhoneNumberNational = x.cleansedPhoneNumberNational
            this.country = x.country
            this.countryCodeIso2 = x.countryCodeIso2
            this.countryCodeNumeric = x.countryCodeNumeric
            this.county = x.county
            this.originalCountryCodeIso2 = x.originalCountryCodeIso2
            this.originalPhoneNumber = x.originalPhoneNumber
            this.phoneType = x.phoneType
            this.phoneTypeCode = x.phoneTypeCode
            this.timezone = x.timezone
            this.zipCode = x.zipCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.NumberValidateResponse = NumberValidateResponse(this)
    }
}
