// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
 */
public class GcmChannelRequest private constructor(builder: Builder) {
    /**
     * The Web API Key, also referred to as an *API_KEY* or *server key*, that you received from Google to communicate with Google services.
     */
    public val apiKey: kotlin.String? = builder.apiKey
    /**
     * The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
     */
    public val defaultAuthenticationMethod: kotlin.String? = builder.defaultAuthenticationMethod
    /**
     * Specifies whether to enable the GCM channel for the application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The contents of the JSON file provided by Google during registration in order to generate an access token for authentication. For more information see [Migrate from legacy FCM APIs to HTTP v1](https://firebase.google.com/docs/cloud-messaging/migrate-v1).
     */
    public val serviceJson: kotlin.String? = builder.serviceJson

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.GcmChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GcmChannelRequest(")
        append("apiKey=$apiKey,")
        append("defaultAuthenticationMethod=$defaultAuthenticationMethod,")
        append("enabled=$enabled,")
        append("serviceJson=$serviceJson")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKey?.hashCode() ?: 0
        result = 31 * result + (defaultAuthenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (serviceJson?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GcmChannelRequest

        if (apiKey != other.apiKey) return false
        if (defaultAuthenticationMethod != other.defaultAuthenticationMethod) return false
        if (enabled != other.enabled) return false
        if (serviceJson != other.serviceJson) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.GcmChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Web API Key, also referred to as an *API_KEY* or *server key*, that you received from Google to communicate with Google services.
         */
        public var apiKey: kotlin.String? = null
        /**
         * The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
         */
        public var defaultAuthenticationMethod: kotlin.String? = null
        /**
         * Specifies whether to enable the GCM channel for the application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The contents of the JSON file provided by Google during registration in order to generate an access token for authentication. For more information see [Migrate from legacy FCM APIs to HTTP v1](https://firebase.google.com/docs/cloud-messaging/migrate-v1).
         */
        public var serviceJson: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.GcmChannelRequest) : this() {
            this.apiKey = x.apiKey
            this.defaultAuthenticationMethod = x.defaultAuthenticationMethod
            this.enabled = x.enabled
            this.serviceJson = x.serviceJson
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.GcmChannelRequest = GcmChannelRequest(this)
    }
}
