// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.
 */
public class ExportJobRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export endpoint definitions to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/.
     */
    public val s3UrlPrefix: kotlin.String? = builder.s3UrlPrefix
    /**
     * The identifier for the segment to export endpoint definitions from. If you don't specify this value, Amazon Pinpoint exports definitions for all the endpoints that are associated with the application.
     */
    public val segmentId: kotlin.String? = builder.segmentId
    /**
     * The version of the segment to export endpoint definitions from, if specified.
     */
    public val segmentVersion: kotlin.Int? = builder.segmentVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ExportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportJobRequest(")
        append("roleArn=$roleArn,")
        append("s3UrlPrefix=$s3UrlPrefix,")
        append("segmentId=$segmentId,")
        append("segmentVersion=$segmentVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (s3UrlPrefix?.hashCode() ?: 0)
        result = 31 * result + (segmentId?.hashCode() ?: 0)
        result = 31 * result + (segmentVersion ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportJobRequest

        if (roleArn != other.roleArn) return false
        if (s3UrlPrefix != other.s3UrlPrefix) return false
        if (segmentId != other.segmentId) return false
        if (segmentVersion != other.segmentVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ExportJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export endpoint definitions to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name/<replaceable>folder-name/.
         */
        public var s3UrlPrefix: kotlin.String? = null
        /**
         * The identifier for the segment to export endpoint definitions from. If you don't specify this value, Amazon Pinpoint exports definitions for all the endpoints that are associated with the application.
         */
        public var segmentId: kotlin.String? = null
        /**
         * The version of the segment to export endpoint definitions from, if specified.
         */
        public var segmentVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ExportJobRequest) : this() {
            this.roleArn = x.roleArn
            this.s3UrlPrefix = x.s3UrlPrefix
            this.segmentId = x.segmentId
            this.segmentVersion = x.segmentVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ExportJobRequest = ExportJobRequest(this)
    }
}
