// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies demographic information about an endpoint, such as the applicable time zone and platform.
 */
public class EndpointDemographic private constructor(builder: Builder) {
    /**
     * The version of the app that's associated with the endpoint.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * The manufacturer of the endpoint device, such as apple or samsung.
     */
    public val make: kotlin.String? = builder.make
    /**
     * The model name or number of the endpoint device, such as iPhone or SM-G900F.
     */
    public val model: kotlin.String? = builder.model
    /**
     * The model version of the endpoint device.
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The platform of the endpoint device, such as ios.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The platform version of the endpoint device.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointDemographic(")
        append("appVersion=$appVersion,")
        append("locale=$locale,")
        append("make=$make,")
        append("model=$model,")
        append("modelVersion=$modelVersion,")
        append("platform=$platform,")
        append("platformVersion=$platformVersion,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appVersion?.hashCode() ?: 0
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (make?.hashCode() ?: 0)
        result = 31 * result + (model?.hashCode() ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointDemographic

        if (appVersion != other.appVersion) return false
        if (locale != other.locale) return false
        if (make != other.make) return false
        if (model != other.model) return false
        if (modelVersion != other.modelVersion) return false
        if (platform != other.platform) return false
        if (platformVersion != other.platformVersion) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The version of the app that's associated with the endpoint.
         */
        public var appVersion: kotlin.String? = null
        /**
         * The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.
         */
        public var locale: kotlin.String? = null
        /**
         * The manufacturer of the endpoint device, such as apple or samsung.
         */
        public var make: kotlin.String? = null
        /**
         * The model name or number of the endpoint device, such as iPhone or SM-G900F.
         */
        public var model: kotlin.String? = null
        /**
         * The model version of the endpoint device.
         */
        public var modelVersion: kotlin.String? = null
        /**
         * The platform of the endpoint device, such as ios.
         */
        public var platform: kotlin.String? = null
        /**
         * The platform version of the endpoint device.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic) : this() {
            this.appVersion = x.appVersion
            this.locale = x.locale
            this.make = x.make
            this.model = x.model
            this.modelVersion = x.modelVersion
            this.platform = x.platform
            this.platformVersion = x.platformVersion
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EndpointDemographic = EndpointDemographic(this)
    }
}
