// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the default settings and content for a message template that can be used in messages that are sent through a push notification channel.
 */
public class DefaultPushNotificationTemplate private constructor(builder: Builder) {
    /**
     * The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The message body to use in push notifications that are based on the message template.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.
     *
     * For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
     */
    public val sound: kotlin.String? = builder.sound
    /**
     * The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultPushNotificationTemplate(")
        append("action=$action,")
        append("body=$body,")
        append("sound=$sound,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (sound?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultPushNotificationTemplate

        if (action != other.action) return false
        if (body != other.body) return false
        if (sound != other.sound) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The message body to use in push notifications that are based on the message template.
         */
        public var body: kotlin.String? = null
        /**
         * The sound to play when a recipient receives a push notification that's based on the message template. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.
         *
         * For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
         */
        public var sound: kotlin.String? = null
        /**
         * The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate) : this() {
            this.action = x.action
            this.body = x.body
            this.sound = x.sound
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationTemplate = DefaultPushNotificationTemplate(this)
    }
}
