// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the default settings and content for a push notification that's sent directly to an endpoint.
 */
public class DefaultPushNotificationMessage private constructor(builder: Builder) {
    /**
     * The default action to occur if a recipient taps the push notification. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The default body of the notification message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The JSON data payload to use for the default push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
     */
    public val data: Map<String, String>? = builder.data
    /**
     * Specifies whether the default notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration or delivering messages to an in-app notification center.
     */
    public val silentPush: kotlin.Boolean? = builder.silentPush
    /**
     * The default message variables to use in the notification message. You can override the default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The default title to display above the notification message on a recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The default URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultPushNotificationMessage(")
        append("action=$action,")
        append("body=$body,")
        append("data=$data,")
        append("silentPush=$silentPush,")
        append("substitutions=$substitutions,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (silentPush?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultPushNotificationMessage

        if (action != other.action) return false
        if (body != other.body) return false
        if (data != other.data) return false
        if (silentPush != other.silentPush) return false
        if (substitutions != other.substitutions) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default action to occur if a recipient taps the push notification. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The default body of the notification message.
         */
        public var body: kotlin.String? = null
        /**
         * The JSON data payload to use for the default push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
         */
        public var data: Map<String, String>? = null
        /**
         * Specifies whether the default notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration or delivering messages to an in-app notification center.
         */
        public var silentPush: kotlin.Boolean? = null
        /**
         * The default message variables to use in the notification message. You can override the default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The default title to display above the notification message on a recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The default URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage) : this() {
            this.action = x.action
            this.body = x.body
            this.data = x.data
            this.silentPush = x.silentPush
            this.substitutions = x.substitutions
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.DefaultPushNotificationMessage = DefaultPushNotificationMessage(this)
    }
}
